# coding: UTF-8

ROOT_PATH = File.dirname(File.expand_path(__FILE__))

$:.unshift(ROOT_PATH + "/../")
$:.unshift(ROOT_PATH + "/../../main/")
$:.unshift(ROOT_PATH + "/../../main/lib")

# mail2weblog のルートパスを設定する
M2W_ROOT_PATH = ROOT_PATH + "/../../main/"

require 'm2w_configurator'
require 'm2w_plugin_manager'

require 'minitest/unit'

MiniTest::Unit.autorun

#=Mail2WeblogPluginManager のテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_m2w_plugin_manager.rb 209 2011-08-17 11:11:43Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestMail2WeblogPluginManager < MiniTest::Unit::TestCase

	def setup
		@plugin_manager = Mail2WeblogPluginManager.new
	end

	def test_command_plugin
		command = @plugin_manager.get_command_plugin('post')
		assert_instance_of Post_CommandPlugin, command
	end

	def test_format_plugin
		format = @plugin_manager.get_format_plugin('img')
		assert_instance_of Img_FormatPlugin, format

		format = @plugin_manager.get_format_plugin('nico')
		assert_instance_of Nico_FormatPlugin, format
	end

	def test_weblog_plugin
		weblog = @plugin_manager.get_weblog_plugin('movable_type')
		assert_instance_of MovableType_WeblogPlugin, weblog

		weblog = @plugin_manager.get_weblog_plugin('word_press')
		assert_instance_of WordPress_WeblogPlugin, weblog

		weblog = @plugin_manager.get_weblog_plugin('fc2')
		assert_instance_of Fc2_WeblogPlugin, weblog
	end

end
