# coding: UTF-8

require 'xmlrpc_support/xmlrpc_parser'
require 'plugin/weblog/meta_weblog/meta_weblog'
require 'plugin/weblog/word_press/word_press_post'

M2W_WEBLOG_WORDPRESS_DEFAULT_ENCODING = 'UTF-8'
M2W_WEBLOG_WORDPRESS_ATTACHMENT_ROOT_PATH = 'attrs'
M2W_WEBLOG_WORDPRESS_XMLRPC_ENCODING = 'UTF-8'

#=WordPress のためのウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: word_press.rb 225 2011-08-20 12:10:42Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class WordPress_WeblogPlugin < MetaWeblog_WeblogPlugin

	def initialize(endpoint = M2W_WEBLOG_ENDPOINT, username = M2W_WEBLOG_USERNAME, password = M2W_WEBLOG_PASSWORD, encoding = M2W_WEBLOG_WORDPRESS_DEFAULT_ENCODING, attachment_root_path = M2W_WEBLOG_WORDPRESS_ATTACHMENT_ROOT_PATH)
		super
	end

	def client
		result = super
		result.set_parser(XMLRPCParser.new(M2W_WEBLOG_WORDPRESS_XMLRPC_ENCODING))
		return result
	end

	# ブログ記事投稿用のプラグインを取得します。
	def get_post_plugin()
		return WordPressPost_WeblogPlugin.new(self)
	end

end
