# coding: UTF-8

#=metaWeblog API を使った標準のブログ記事投稿用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: metaweblog_post_extension.rb 132 2011-08-06 00:33:02Z yutaka_at_home $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class MetaWeblogPost_WeblogPlugin

	attr_reader :report

	def initialize(parent)
		@parent = parent
		@report = {}
	end

	def header_alias
		return {}
	end

	def post(header, content, attachments, blogid)
		M2W_LOGGER.debug("Start  #{self.class.name}#post ... endpoint = #{@parent.endpoint}, blogid = #{blogid}, header = #{header.to_s}")

		client = @parent.client
		formatter = @parent.formatter

		before(client, header, content, attachments, blogid)

		# 事前フォーマットする
		header['description'] = formatter.preformat(
			content,
			@parent.mail_sender.make_content(header, content),
			attachments != nil && !attachments.empty?)

		header = @parent.mail_parser.get_alias_header(header, M2W_META_WEBLOG_POST_HEADER_ALIAS)

		# ブログ記事を投稿する
		M2W_LOGGER.debug("Start  metaWeblog.newPost ... header = #{header.to_s}")
		postid = client.call("metaWeblog.newPost", blogid, @parent.username, @parent.password, header, 1)
		@report[:postid] = postid
		M2W_LOGGER.debug("Finish metaWeblog.newPost ... postid = #{postid}")

		# 添付ファイルを投稿する
		attachment_urls = nil
		if attachments.size > 0 then
			attachment_urls = {}
			attachment_index = 1
			attachments.each do |attachment|
				M2W_LOGGER.debug("Start  metaWeblog.newMediaObject ... index = #{attachment_index}, filename = #{attachment.filename}")
				media_result = attachment_urls[attachment_index] = client.call("metaWeblog.newMediaObject", blogid, @parent.username, @parent.password,
					{"bits" => XMLRPC::Base64.new(attachment.content), "name" => @parent.get_attachment_filepath(postid, attachment_index, attachment.filename)}
				)
				if media_result != nil then
					attachment_urls[attachment_index] = media_result['url']
				end
				M2W_LOGGER.debug("Finish metaWeblog.newMediaObject ...")
				attachment_index = attachment_index + 1
			end
			@report[:attachment_urls] = attachment_urls.clone
		end

		# 事後フォーマットをして、ブログ記事を編集投稿する
		# ※ 編集投稿する理由は、以下の２つ。
		# １．一度投稿しないと postid をプラグインに伝えられないから。postid を使うプラグインを想定している。
		# ２．添付ファイルの URL も postid に依存するから。添付ファイルの URL をのちのち取得できるように保存しておく。
		# いずれの理由も一度投稿しないと確定しない postid に依存する点で共通している。
		if formatter.has_plugin_content || attachment_urls != nil then
			vars = {:blogid => blogid, :postid => postid, :encoding => @parent.encoding}
			vars = vars.merge(header)
			if attachment_urls != nil then
				vars[:attachment_urls] = attachment_urls
			end
			M2W_LOGGER.debug("Start  metaWeblog.editPost ...")
			header['description'] = formatter.postformat(header['description'], vars)
			edit_successed = client.call("metaWeblog.editPost", postid, @parent.username, @parent.password, header, 1)
			@report[:edit_successed] = edit_successed
			M2W_LOGGER.debug("Finish metaWeblog.editPost ... result = #{edit_successed}")
		end

		after(client, header, content, attachments, blogid, postid)

		M2W_LOGGER.debug("Finish #{self.class.name}#post")
		return true
	end

	def before(client, header, content, attachments, blogid)
	end

	def after(client, header, content, attachments, blogid, postid)
	end

end
