# coding: UTF-8

require 'xmlrpc/client'

#=metaWeblog API を使った標準のブログ編集投稿用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: meta_weblog_edit.rb 233 2011-08-21 13:17:13Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class MetaWeblogEdit_WeblogPlugin

	attr_reader :report

	def initialize(parent)
		@parent = parent
		@report = {}
	end

	def header_alias
		return {}
	end

	def edit(header, content, attachments, blogid)
		M2W_LOGGER.debug("Start  #{self.class.name}#edit ... endpoint = #{@parent.endpoint}, blogid = #{blogid}, header = #{header.to_s}")

		result = false

		client = @parent.client
		formatter = @parent.formatter

		postid = header['postid']
		header.delete('postid')

		if postid != nil then
			before(client, header, content, attachments, blogid, postid)

			# 事前フォーマットする
			header['description'] = formatter.preformat(
				content,
				@parent.mail_sender.make_content(header, content),
				attachments != nil && !attachments.empty?)

			header = @parent.mail_parser.get_alias_header(header, M2W_META_WEBLOG_POST_HEADER_ALIAS)

			# 添付ファイルを投稿する
			attachment_urls = nil
			if attachments.size > 0 then
				attachment_urls = {}
				attachment_index = 1
				attachments.each do |attachment|
					M2W_LOGGER.debug("Start  metaWeblog.newMediaObject ... index = #{attachment_index}, filename = #{attachment.filename}")
					media_result = attachment_urls[attachment_index] = client.call("metaWeblog.newMediaObject", blogid, @parent.username, @parent.password,
						{"bits" => XMLRPC::Base64.new(attachment.content), "name" => @parent.get_attachment_filepath(postid, attachment_index, attachment.filename)}
					)
					if media_result != nil then
						attachment_urls[attachment_index] = media_result['url']
					end
					M2W_LOGGER.debug("Finish metaWeblog.newMediaObject ...")
					attachment_index = attachment_index + 1
				end
				@report[:attachment_urls] = attachment_urls.clone
			end

			# 事後フォーマットする
			if formatter.has_plugin_content || attachment_urls != nil then
				vars = {:blogid => blogid, :postid => postid, :encoding => @parent.encoding}
				vars = vars.merge(header)
				if attachment_urls != nil then
					vars[:attachment_urls] = attachment_urls
				end
				header['description'] = formatter.postformat(header['description'], vars)
			end

			# ブログ記事を編集投稿する
			M2W_LOGGER.debug("Start  metaWeblog.editPost ...")
			result = client.call("metaWeblog.editPost", postid, @parent.username, @parent.password, header, 1)
			@report[:postid] = postid
			M2W_LOGGER.debug("Finish metaWeblog.editPost ... result = #{result}")

			after(client, header, content, attachments, blogid, postid)

			M2W_LOGGER.debug("Finish #{self.class.name}#edit ... result = #{result}")
		end

		return result
	end

	def before(client, header, content, attachments, blogid, postid)
	end

	def after(client, header, content, attachments, blogid, postid)
	end

end
