# coding: UTF-8

require 'plugin/weblog/meta_weblog/meta_weblog_post'

M2W_WEBLOG_MT_CATEGORIES = 'categories'

#=Movable Type のための投稿用拡張モジュールです。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: movable_type_post.rb 182 2011-08-09 21:22:41Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class MovableTypePost_WeblogPlugin < MetaWeblogPost_WeblogPlugin

	def header_alias
		return {'keys' => 'mt_keywords', 'tags' => 'mt_tags', 'cats' => M2W_WEBLOG_MT_CATEGORIES}
	end

	def before(server, header, content, attachments, blogid)
		@categories = header[M2W_WEBLOG_MT_CATEGORIES]
		header.delete(M2W_WEBLOG_MT_CATEGORIES)
	end

	def after(server, header, content, attachments, blogid, postid)
		set_post_categories(server, blogid, postid, @categories)
		publish_post(server, postid)
	end

	# ブログ記事にカテゴリを設定する
	def set_post_categories(server, blogid, postid, categories)
		if categories != nil then
			M2W_LOGGER.info("Start	mt.getCategoryList ... categories = #{categories}")
			category_map = get_category_map(server.call("mt.getCategoryList", blogid, @parent.username, @parent.password))
			M2W_LOGGER.info("Finish mt.getCategoryList ... category_map = #{category_map}")

			M2W_LOGGER.info("Start	mt.setPostCategories ... categories = #{categories}")
			result = server.call(
				"mt.setPostCategories",
				postid, @parent.username, @parent.password,
				get_category_array(categories, category_map))
			M2W_LOGGER.info("Finish mt.setPostCategories ...")
		end
	end

	# ブログ記事の再構築を行う
	def publish_post(server, postid)
		M2W_LOGGER.info("Start	mt.publishPost ... postid = #{postid}")
		result = server.call("mt.publishPost", postid, @parent.username, @parent.password)
		M2W_LOGGER.info("Finish mt.publishPost ... postid = #{postid}")
	end

	def get_category_map(categories)
		result = {}
		# カテゴリ名はカテゴリＩＤにマップする
		categories.each do |category|
			result[category['categoryId']] = category['categoryId']
		end

		# カテゴリＩＤはそのままカテゴリＩＤにマップする
		#
		# （※）
		# このカテゴリマップ作成の順番は、
		# カテゴリ名にカテゴリＩＤと重複するものが存在する場合、カテゴリ名を優先するということを意味する。
		# 恐らくはレアケースと思われるが、人間へのわかりやすさという観点からそう決定する。
		categories.each do |category|
			result[category['categoryName']] = category['categoryId']
		end
		return result
	end

	def get_category_array(categories, category_map)
		result = []
		categories.split(",").each do |category|
			if category_map.has_key?(category) then
				result.push({"categoryId" => category_map[category]})
			else
				# 存在しないカテゴリは無視する
			end
		end
		return result
	end

end
