# coding: UTF-8

require 'style/formatter'

M2W_WEBLOG_FC2_LINE_BREAK = "&lb;"

class Fc2Formatter < Formatter

	def escape(content)
		result = CGI.escapeHTML(content)
		return result.gsub(/\n/, M2W_WEBLOG_FC2_LINE_BREAK)
	end

	def unescape(content)
		result = content.gsub(M2W_WEBLOG_FC2_LINE_BREAK, "\n")
		return CGI.unescapeHTML(result)
	end

end
