# coding: UTF-8

require 'plugin/weblog/metaweblog/metaweblog_extension'
require 'plugin/weblog/fc2/fc2_post_extension'

M2W_WEBLOG_FC2_DEFAULT_ENCODING = 'UTF-8'
M2W_WEBLOG_FC2_ATTACHMENT_ROOT_PATH = 'attrs'

#=FC2 ブログのための拡張モジュールです。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: fc2_extension.rb 102 2011-06-27 11:08:50Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class FC2Extension < MetaWeblogExtension

	def initialize(host = M2W_WEBLOG_HOST, address = M2W_WEBLOG_ADDRESS, username = M2W_WEBLOG_USERNAME, password = M2W_WEBLOG_PASSWORD, encoding = M2W_WEBLOG_FC2_DEFAULT_ENCODING, attachment_root_path = M2W_WEBLOG_FC2_ATTACHMENT_ROOT_PATH)
		super
	end

	# ブログへ投稿する際の拡張モジュールを取得する
	def newPostExtension()
		return FC2PostExtension.new(self)
	end

end
