# coding: UTF-8

require 'mailutils/mail_processor'

#=メールを基にブログへのコマンドを発行するブログコマンド
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: weblog_command.rb 121 2011-07-17 12:26:08Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
#
# 発行するコマンドの種類は、メールタイトル（Subject ヘッダー）で判断します。
#
# 想定するメールタイトルのフォーマットは以下の通りです。
#
# header:コマンド名:パラメータ
#
# hedaer は、コンストラクタで指定した任意の文字列です。
# 本クラスは、メールタイトルが上記フォーマットにマッチしないメールを無視します。
#
# 該当するメールであることが分かった場合は、コマンド名に応じた処理を実行します。
# コマンドの詳細は、コマンドを実行する各クラスを参照してください。
#
# コマンドが成功したと認識した場合、本クラスはメールボックスから該当のメールを削除します。
class WeblogCommand

	def initialize(weblog, parser, sender)
		@weblog = weblog
		@parser = parser
		@sender = sender
	end

	def encoding
		if @weblog != nil then
			return @weblog.encoding
		else
			return M2W_XMLRPC_ENCODING
		end
	end

	def run(m)
		mail = MailProcessor.parse(m.pop, encoding())
		begin
			header_parsed_result = @parser.parse_header(mail, encoding())
			if header_parsed_result != nil then
				command_name = header_parsed_result[0]
				param = header_parsed_result[1]

				M2W_LOGGER.info("Processing ... #{mail.subject}")

				command_class = M2W_COMMAND_CLASSES[command_name]
				if command_class != nil then
					command = eval("#{command_class}").new()
				else
					M2W_LOGGER.error("不明なコマンド(#{command_name})を実行しようとしました。")
					command = nil
				end

				if command != nil then
					(header, content, attachments) = @parser.parse_body(mail, command.header_alias(@weblog), encoding())
					if command.run(@weblog, mail.from_address, mail.to_addresses, header, content, attachments, param, @sender) then
						m.delete
					end
				end

				return true
			end
		rescue =>e
			M2W_LOGGER.error("ブログコマンド実行中に予測不能なエラーが発生しました。")
			M2W_LOGGER.error(e)
			M2W_LOGGER.error(m.pop)
			m.delete
			if M2W_REPLY then
				@sender.sendmail_as_command("error", nil, {}, "ブログコマンド実行中に予測不能なエラーが発生しました。", mail.from_address, [])
			end
		end
		return false
	end

end
