# coding: UTF-8

#=メール解析
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: m2w_mail_parser.rb 126 2011-07-20 10:51:49Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Mail2WeblogMailParser

	def initialize(subject_header, subject_separator, header_alias = {})
		@subject_header = subject_header
		@subject_separator = subject_separator
		if header_alias != nil then
			@header_alias = header_alias.clone
		else
			@header_alias = {}
		end
	end

	def parse_header(mail, encoding)
		if @subject_header != nil then
			if mail.subject.encode(encoding) =~ /^#{@subject_header}#{@subject_separator}(.+?)#{@subject_separator}(.+?)$/ then
				command_name = $1
				param = $2
				return [command_name, param]
			elsif mail.subject.encode(encoding) =~ /^#{@subject_header}#{@subject_separator}(.+?)$/ then
				command_name = $1
				return [command_name, '']
			end
		else
			if mail.subject.encode(encoding) =~ /^(.+?)#{@subject_separator}(.+?)$/ then
				command_name = $1
				param = $2
				return [command_name, param]
			else
				return [mail.subject.encode(encoding), '']
			end
		end

		return nil
	end

	def parse_body(mail, header_alias_plus, encoding)
		buffers = mail.content.encode(encoding).split(/\r\n|\r|\n/)
		header_alias = @header_alias.merge(header_alias_plus)

		# ヘッダーを読み込む（改行までがヘッダー）
		header = {}
		i = 0
		while i < buffers.size && buffers[i] != ''
			line = buffers[i]

			if line =~ /^([a-zA-Z_]+?)#{@subject_separator}(.+)$/ then
				key = $1
				value = $2
				if header_alias.has_key?(key) then
					header[header_alias[key]] = value
				else
					header[key] = value
				end
			end

			i = i + 1
		end

		# 本文を読み込む
		i = i + 1
		content = ''
		while i < buffers.size
			content << buffers[i]

			if i != buffers.size - 1 then
				content << "\n"
			end

			i = i + 1
		end

		return [header, content, mail.attachments]
	end

end
