# coding: UTF-8

# mail2weblog へのコマンドであることを判断するためのメールタイトルのヘッダー文字列を指定します。
# 本設定は、mail2weblog 宛のメールとそれ以外のメールを振り分けるためのものです。
# ここに指定した文字列がメールタイトルにあることを mail2weblog は検知して動作します。
#
# 全てのメールが mail2weblog 宛のものであると想定され、またより少ないメールタイトルで処理できるようにするため、
# nil を指定することで、メールタイトルのヘッダー文字列を省略することもできます。
# 例）m2w
M2W_SUBJECT_HEADER = 'm'

# メールタイトルもしくはメール本文ヘッダーのセパレータとしてデフォルトで用いる文字列を指定します。
M2W_SUBJECT_SEPARATOR = "."

# メールタイトルもしくはメール本文ヘッダーのセパレータを判断するための正規表現を指定します。
M2W_SUBJECT_SEPARATOR_REGEX = "[\./:]"

# ブログへの投稿を行うコマンドであることを判断するために使う文字列を指定します。
M2W_POST_COMMAND = 'post'

# ブログへの投稿時に使用するヘッダー名称に使いやすさを考慮した短縮系の別名を定義します。
#
# ブログへの投稿を行う際、メール本文のヘッダーでブログのタイトルや投稿日付などの情報を指定します。
# 形式は、以下の通りです。
#
# ヘッダー１名:ヘッダー１値（例：title:今日は良い一日でした。）
# ヘッダー２名:ヘッダー２値（例：dateCreated:20110330T12:30:00）
# ... 以下、空行までヘッダーの指定が可能 ...
#
# ブログ記事本文
#
# これらのヘッダーの名称は、content 構造体に由来します（「description＝ブログ記事の本文」を除く）。
# エイリアス
M2W_POST_COMMAND_HEADER_ALIAS = {
  'tit' => 'title',
  'dat' => 'dateCreated',
}

# XML-RPC を送信する際のデフォルトのエンコードを指定します。
M2W_XMLRPC_ENCODING = 'UTF-8'
