# coding: UTF-8

#=メール解析
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: m2w_mail_parser.rb 102 2011-06-27 11:08:50Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Mail2WeblogMailParser

	def initialize(headerAlias = {})
		if headerAlias != nil then
			@headerAlias = headerAlias.clone
		else
			@headerAlias = {}
		end
	end

	def parse(mail, encoding)
		buffers = mail.content.encode(encoding).split(/\r\n|\r|\n/)

		# ヘッダーを読み込む（改行までがヘッダー）
		header = {}
		i = 0
		while i < buffers.size && buffers[i] != ''
			line = buffers[i]

			if line =~ /^([a-zA-Z_]+):(.+)$/ then
				key = $1
				value = $2
				if @headerAlias.has_key?(key) then
					header[@headerAlias[key]] = value
				else
					header[key] = value
				end
			end

			i = i + 1
		end

		# 本文を読み込む
		i = i + 1
		content = ''
		while i < buffers.size
			content = content + buffers[i] + "\n"

			i = i + 1
		end

		return [header, content, mail.attachments]
	end

end
