# coding: UTF-8

ROOT_PATH = File.dirname(File.expand_path(__FILE__))

$:.unshift(ROOT_PATH + "/")
$:.unshift(ROOT_PATH + "/../")
$:.unshift(ROOT_PATH + "/../../main/")
$:.unshift(ROOT_PATH + "/../../main/lib")

require 'net/http'
require 'net/pop'
require 'net/smtp'

# mail2weblog のルートパスを設定する
M2W_ROOT_PATH = ROOT_PATH + "/../../main/"

require 'accessor'
require 'm2w_configurator'
require 'conf/setting'
require 'mailutils/mail_processor'

require 'minitest/unit'

MiniTest::Unit.autorun

#=mail2weblog のテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test.rb 96 2011-06-25 12:22:53Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestMail2Weblog < MiniTest::Unit::TestCase

	if REAL_M2W_TEST then
		# リアルメール送受信テストです。
		# 本テストは、設定（conf/setting.rb）に依存します。
		# また、本テストは、SMTP サーバへの認証に SMTP Authentication を想定しています。
		def test_real
			if %r!^http://(.+?)(/.*)$! =~ M2W_WEBLOG_BASE_URL[WEBLOG_BLOG_ID] then
				weblog_host = $1
				weblog_address = $2
			else
				assert false
			end

			# メールを送信する
			from_address = MailAddress.new(SMTP_SERVER_MAILADDRESS)
			to_addresses = [MailAddress.new(POP3_SERVER_MAILADDRESS)]
			keyword = Time.now.asctime
			title = "タイトルテスト(#{keyword})"
			message = "コンテンツテスト(#{keyword})"
content = <<"END_CONTENT"
tit:#{title}

#{message}
END_CONTENT
			Net::SMTP.start(M2W_SMTP_SERVER_ADDRESS, M2W_SMTP_SERVER_PORT, M2W_SMTP_SERVER_ADDRESS, M2W_SMTP_SERVER_USER, M2W_SMTP_SERVER_PASSWORD, :login) do |smtp|
				smtp.send_message(
					MailProcessor.make(Mail.new("m2w:post:#{WEBLOG_BLOG_ID}", from_address, to_addresses, content, []), Time.local(2011, 1, 2, 3, 4, 5, 6)),
					from_address.address, MailProcessor.make_address_list(to_addresses)
				)
			end

			sleep(5)

			assert system("ruby #{ROOT_PATH}/../../main/m2w.rb")
			response = Accessor.access(weblog_host, weblog_address, WEBLOG_ENCODING)

			assert_match title.encode(WEBLOG_ENCODING), response
			assert_match message.encode(WEBLOG_ENCODING), response
		end
	end

end
