# coding: UTF-8

require 'base64'

require 'm2w_common'

#=簡易メール情報取得ユーティリティー（添付ファイル）
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: mailpart.rb 46 2011-06-07 11:40:08Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class MailPart

	attr_reader :header
	attr_reader :body

	def initialize(header, body)
		@header = header
		@body = body
	end

	def filename
		if /name="(.+)"/ =~ @header['Content-Type'] then
			result = $1
			if /^=\?(.+?)\?([BQ])\?(.+)\?=$/ =~ result then
				# ＢもしくはＱ符号化されている
				encoding = $1
				encoding_type = $2
				encoded_filename = $3
				if encoding_type == "B"  then
					return m2w_encode(Base64::decode64(encoded_filename), M2W_XMLRPC_ENCODING, encoding)
				elsif encoding_type == "Q" then
					raise EncodingError.new('Ｑ符号化されたファイル名はサポートしていません。')
				end
			else
				# 特に符号化されていない
				return result
			end
		else
			return nil
		end
	end

	def decode
		if 'base64' != @header['Content-Transfer-Encoding'] then
			raise EncodingError.new('base64 以外の Content-Transfer-Encoding を持つ添付ファイルはサポートしていません。')
		end

		return Base64::decode64(@body)
	end

end
