# coding: UTF-8

require 'mail'

require 'command/weblog_post'

#=メールを基にブログへのコマンドを発行するブログコマンド
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: weblog_command.rb 39 2011-06-01 13:51:30Z yutaka_at_home $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
#
# 発行するコマンドの種類は、メールタイトル（Subject ヘッダー）で判断します。
#
# 想定するメールタイトルのフォーマットは以下の通りです。
#
# M2W_SUBJECT_HEADER:コマンド名:パラメータ
#
# M2W_SUBJECT_HEADER は、m2w_config.rb で定義している定数です。
# 本クラスは、メールタイトルが上記フォーマットにマッチしないメールを無視します。
#
# 該当するメールであることが分かった場合は、コマンド名に応じた処理を実行します。
# コマンドの詳細は、コマンドを実行する各クラスを参照してください。
#
# コマンドが成功したと認識した場合、本クラスはメールボックスから該当のメールを削除します。
class WeblogCommand

	def initialize(host, address, username, password)
		@host = host
		@address = address
		@username = username
		@password = password
	end

	def run(m)
		begin
			mail = Mail.new(m.pop)
			if mail.header('Subject') =~ /^#{M2W_SUBJECT_HEADER}:(.+):(.+)/ then
				command_name = $1
				param = $2

				M2W_LOGGER.info("Processing ... #{mail.header('Subject')}")

				extension = nil
				case command_name
				when M2W_POST_COMMAND
					if M2W_WEBLOG_EXTENSION != nil then
						extension = M2W_WEBLOG_EXTENSION.newPostExtension
					end
					command = WeblogPost.new(@host, @address, @username, @password, param, mail)
				else
					M2W_LOGGER.error("不明なコマンド(#{command_name})を実行しようとしました。")
					command = nil
				end

				if command != nil then
					if command.run(extension) then
						m.delete
					end
				end

				return true
			end
		rescue =>e
			M2W_LOGGER.error("ブログコマンド実行中に予測不能なエラーが発生しました。")
			M2W_LOGGER.error(e)
			M2W_LOGGER.info(m.pop)
			m.delete
		end
		return false
	end

end
