# coding: UTF-8

#=dumpmail ツールでファイルにダンプしたメールを Mail クラスで解析可能かどうかを試すツールです。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id$
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)

# LOAD_PATH に lib フォルダを追加する
$:.unshift(File.dirname(__FILE__) + "/../../main/lib/")

require 'optparse'

require 'mail'

# 引数を解析する
# デフォルト値を設定する
DEFAULT_DIRECTORY = '../dumpmail/dump/'
config = {'directory' => DEFAULT_DIRECTORY}
OptionParser.new do |opts|
	# オプション情報を設定する
	opts = OptionParser.new
	opts.on('-f FILE', '--file FILENAME', '[必須]解析対象となるファイルを指定する。') {|filename| config['filename'] = filename}
	opts.on('-d DIRECTORY', '--dir DIRECTORY', "[任意]解析対象となるファイルが存在するフォルダを指定する。指定しなかった場合は、#{DEFAULT_DIRECTORY} とする。") {|directory| config['directory'] = directory}
	opts.on('-e ENCODING', '--encoding ENCODING', "[任意]解析対象となるファイルが存在するフォルダを指定する。指定しなかった場合は、#{DEFAULT_DIRECTORY} とする。") {|encoding| config['encoding'] = encoding}
	opts.on('--debug', '[任意]デバッグ情報を標準エラー出力に出力する場合に指定する。指定しなかった場合は dump ふぉデフォルトとする。') {config['debug'] = true}

	opts.parse!(ARGV)

	# 必須オプションをチェックする
	required = ['filename', 'directory']
	for field in required
		if config[field] == nil then
      p config
			puts opts.help
			exit 1
		end
	end
end

file = File.open("#{config['directory']}#{config['filename']}", "r")
buffer = file.read

puts "== MAIL CONTENTS =="
puts buffer

mail = Mail.new(buffer)

puts "== ANALYZED HEADER =="
mail.header_keys.each do |key|
  puts "#{key} => #{mail.header(key)}"
end

puts "== ANALYZED BODY =="
if config['encoding'] != nil then
  puts mail.body(config['encoding'])
else
  puts mail.body()
end
