# coding: UTF-8

require 'net/pop'

#=メールを契機に処理を実行するメールコマンドプロセッサー
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id$
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
#
# メールを契機に何らかの処理を実行するための基盤となるメールコマンドプロセッサーです。
# 本クラスは、あくまで基盤です。以下の役割を担います。
#
# - net/pop ライブラリを利用し、メールを受信する。
# - あらかじめ add メソッドで追加されたコマンドに受信したメールを渡して処理させる。
#
# run メソッドが上記動作を実行します。
# １度の run メソッド呼び出しで本クラスは１度のメール走査を行います。
# 定期実行を行いたい場合は、外部プログラムでの対応が必要になります。
#
# また、本クラスは受信したメールをメールボックスから削除する動作は行いません。
# 処理したメールを削除したい場合には、コマンド側でメールの delete メソッドを呼び出す対応を行ってください。
class MailCommandProcessor

  # メールコマンドプロセッサーを構築します。
  def initialize(pop3_server_address, pop3_server_port = 110, pop3_server_user = nil, pop3_server_password = nil)
    @pop3_server_address = pop3_server_address
    @pop3_server_port = pop3_server_port
    @pop3_server_user = pop3_server_user
    @pop3_server_password = pop3_server_password

    @commands = []
  end

  # コマンドを追加します。
  def add(command)
    @commands.push(command)
  end

  # メールボックスにあるメールを読み込み、コマンドを実行します。
  # コマンドの実行順序は、add メソッドにより登録した順序となります。
  # コマンドの run メソッドを順番に実行し、戻り値として true が帰ってきた場合は、メールが処理されたと判断して以降のコマンドは実行しません。
  def run
    pop = Net::POP3.new(@pop3_server_address, @pop3_server_port)
    pop.start(@pop3_server_user, @pop3_server_password)
    pop.each_mail do |m|
      i = 0
      while i < @commands.size
        if @commands[i].run(m) then
          break
        end
        i = i + 1
      end
    end
    pop.finish
  end

end
