# coding: UTF-8

require 'plugin/weblog/meta_weblog/meta_weblog_edit'

#=Movable Type のためのブログ記事編集用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: movable_type_edit.rb 584 2012-03-11 04:33:39Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class MovableTypeEdit_WeblogPlugin < MetaWeblogEdit_WeblogPlugin

	def header_alias
		result = super
		return result.merge(@parent.header_alias_for_post)
	end

	def before(client, request, blogid, postid, errors, warnings)
		if request.header['mt_tb_ping_urls'] != nil then
			request.header['mt_tb_ping_urls'] = request.header['mt_tb_ping_urls'].split(/[\s,]/)
		end

		@categories = request.header[M2W_WEBLOG_MT_CATEGORIES]
		request.header.delete(M2W_WEBLOG_MT_CATEGORIES)
	end

	def after(client, request, blogid, postid, errors, warnings)
		@parent.set_post_categories(client, blogid, postid, @categories, @errors, @warnings)
		@parent.publish_post(client, postid, @errors, @warnings)
	end

end
