# coding: UTF-8

require 'mailutils/mail_processor'
require 'plugin/command/lib/standard_command'

#=ブログ記事編集コマンド
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: edit.rb 595 2012-03-14 02:29:51Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Edit_CommandPlugin < StandardCommand

	def run_before_parsing
		if @weblog != nil then
			@weblog 
			@edit_plugin = @weblog.get_edit_plugin
		end
	end

	def header_alias()
		result = {}

		if @edit_plugin != nil then
			result = result.merge(@edit_plugin.header_alias)
		end

		return result
	end

	def run_after_parsing(request)
		header = request.header
		contents = request.contents

		@report = {}

		if @edit_plugin != nil then
			result = @edit_plugin.edit(request, @param)
			@report = @edit_plugin.report.clone
			@report[:errors] = @edit_plugin.errors
			@report[:warnings] = @edit_plugin.warnings

			if M2W_REPLY && @mail_sender != nil then
				(command, blogid) = @mail_parser.parse_subject(@mail.escaped_prefix_subject)

				if result then
send_content = <<"END_CONTENT"
ブログ記事の編集に成功しました。

編集したブログ記事を編集したい場合は、本メールをそのまま返信すると編集用のメールが届きます。
#{make_exception_contents(@edit_plugin.errors, @edit_plugin.warnings)}
END_CONTENT
					@mail_sender.sendmail_as_command("get", blogid, {"postid" => @report[:postid]}, send_content, @mail.from_address, [])
				else
send_content = <<"END_CONTENT"
ブログ記事の編集に失敗しました。
#{make_exception_contents(@edit_plugin.errors, @edit_plugin.warnings)}
END_CONTENT
					@mail_sender.sendmail_as_command("error", blogid, {}, send_content, @mail.from_address, [])
				end
			end

			return result
		end

		return false
	end

end
