# coding: UTF-8

require 'plugin/weblog/atom_pub/atom_pub_edit'

#=はてなダイアリーのためのブログ編集投稿用ウェブログプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: hatena_diary_edit.rb 864 2012-10-23 22:36:39Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class HatenaDiaryEdit_WeblogPlugin < AtomPubEdit_WeblogPlugin

	def post_medias(client, username, password, blogid, media_posters, errors, warnings)
		@logger.debug("Start  #{self.class.name}#post_medias") if @logger && @logger.debug?
		if media_posters != nil then
			media_posters.each do |media_poster|
				warnings.push(WeblogPluginError.new(
					"ファイル転送未対応(転送ファイル名 = #{media_poster.media_name})",
					"ファイルの転送に対応していません（転送ファイル名 = #{media_poster.media_name}）。"))
			end
		end
		@logger.debug("Finish #{self.class.name}#post_medias") if @logger && @logger.debug?
	end

	def after(client, request, response)
		super

		request_trackback(client, request.header, response[:blogid], response[:postid], response[:formatted_contents]['description'])
	end

end
