# coding: UTF-8

require 'mailutils/mail_processor'
require 'plugin/command/lib/standard_command'

#=ブログ記事取得コマンドプラグイン
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: get.rb 864 2012-10-23 22:36:39Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Get_CommandPlugin < StandardCommand

	def get_plugin
		return @get_plugin if @get_plugin
		@get_plugin = @weblog.get_get_plugin
		@get_plugin.logger = @logger if @get_plugin
		return @get_plugin
	end

	def header_alias()
		result = {}

		result = result.merge(get_plugin.header_alias) if get_plugin

		return result
	end

	def run_after_parsing(request)
		if get_plugin != nil then
			return get_plugin.get(request)
		else
			return Mail2WeblogResponse.new
		end
	end
end
