# coding: UTF-8

#=HTML 本文のフォーマット変換を行います。
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: formatter4html.rb 782 2012-07-27 02:10:05Z toy_dev $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class Formatter4HTML

	IMG_TEMPLATE_LIST = {
		'template_simple' => '<a ${attachment_href}><img ${thumbnail_src} ${alt_a} /></a>',
		'template_hs.b' => '<a ${attachment_href} class="highslide" onclick="return hs.expand(this)"><img ${thumbnail_src} ${alt_a} /></a>',
		'template_hs.bc' => '<a ${attachment_href} class="highslide" onclick="return hs.expand(this)"><img ${thumbnail_src} ${alt_a} /></a><div class="highslide-caption"><p>${caption_v}</p></div>',
	}

	def Formatter4HTML.to_xhtml(content, plugin_manager, vars)
		result = ""

		# プラグインの印をつける
		state = 0
		buffers = content.split(/\n/)
		i = 0
		while i < buffers.size
			line = buffers[i]
			block = true
			while true
				if line =~ /^(.*?)\{\{(.*)$/ then
					left = $1
					right = $2
					result << left
					block = block && ((left =~ /^(<(div|p[^>]*?)>|)$/i) == 0)
					if right =~ /^(.*?)\}\}(.*?)$/ then
						plugin_content = $1
						line = $2

						block = block && ((line =~ %r!^(</(div|p)>|<(br|p)[^>]*?/?>|)$!i) == 0)
						result << __plugin_content(plugin_content, block)
					else
						plugin_content = right
						plugin_content << "\n"
						(multiline_content, line_count, line) = __process_multiline_plugin(buffers, i)
						i = i + line_count
						plugin_content << multiline_content
						if line != nil then
							block = block && ((line =~ %r!^(</(div|p)>|<(br|p)[^>]*?/?>|)$!i) == 0)
							result << __plugin_content(plugin_content, block)
						else
							result << "{{"
							result << plugin_content.chomp
							result << "\n"
							break
						end
					end
				else
					result << line
					result << "\n"
					break
				end
			end

			i = i + 1
		end

		# 関連ファイルの URL を埋め込む
		urls = {}
		urls.merge!(vars[:related_attachment_urls]) if vars[:related_attachment_urls] != nil

		urls.each do |url_id, url|
			result = __translate_url(result, url_id, url, vars[:related_thumbnail_urls][url_id], plugin_manager, vars)
		end

		return result
	end

	def Formatter4HTML.__process_multiline_plugin(buffers, i)
		line_count = 1
		plugin_content = ""

		while i + line_count < buffers.size
			if buffers[i + line_count] =~ /^(.*?)\}\}(.*?)$/ then
				left = $1
				right = $2
				plugin_content << left
				plugin_content << "\n"
				plugin_content.gsub!(/<[^>]+?>/, "")
				return [plugin_content.chomp, line_count, right]
			else
				plugin_content << buffers[i + line_count]
				plugin_content << "\n"
			end

			line_count = line_count + 1
		end

		plugin_content.gsub!(/<[^>]+?>/, "")
		return [plugin_content.chomp, line_count, nil]
	end

	def Formatter4HTML.__plugin_content(plugin_content, block)
		if block then
			return %Q!<div class="plugin">{{#{CGI.unescapeHTML(plugin_content)}}}</div>!
		else
			return %Q!<span class="plugin">{{#{CGI.unescapeHTML(plugin_content)}}}</span>!
		end
	end

	def Formatter4HTML.__translate_url(content, url_id, url, thumbnail_url, plugin_manager, vars)
		template_name = __get_template_name(plugin_manager, vars)
		if thumbnail_url == nil || template_name == nil then
			return content.gsub("cid:#{url_id}", url)
		else
			if IMG_TEMPLATE_LIST.has_key?("template_#{template_name}") then
				template = IMG_TEMPLATE_LIST["template_#{template_name}"]
				template_vars = {}
				if url != nil then
					template_vars["${attachment_href}"] = %Q!href="#{CGI.escapeHTML(url)}"!
					template_vars["${attachment_src}"] = %Q!src="#{CGI.escapeHTML(url)}"!
					template_vars["${attachment_url_v}"] = "#{CGI.escapeHTML(url)}"
				end
				if thumbnail_url != nil then
					template_vars["${thumbnail_href}"] = %Q!href="#{CGI.escapeHTML(thumbnail_url)}"!
					template_vars["${thumbnail_src}"] = %Q!src="#{CGI.escapeHTML(thumbnail_url)}"!
					template_vars["${thumbnail_url_v}"] = "#{CGI.escapeHTML(thumbnail_url)}"
				end

				return content.gsub(%r!<img[^>]*?cid:#{url_id}[^>]*?>!i, __apply_template(template, template_vars))
			else
				raise FormatPluginWarning.new(
					%Q!画像テンプレート指定ミス(テンプレート名 = template_#{template_name})!,
					%Q!指定した画像テンプレートがありませんでした(テンプレート名 = template_#{template_name})。!)
			end
		end
	end

	def Formatter4HTML.__get_template_name(plugin_manager, vars)
		if plugin_manager.weblog_plugin_config["COMMON"] != nil && plugin_manager.weblog_plugin_config["COMMON"]["img_template_name"] != nil then
			return plugin_manager.weblog_plugin_config["COMMON"]["img_template_name"]
		elsif vars["img_template_name"] != nil then
			return vars["img_template_name"]
		else
			return nil
		end
	end

	def Formatter4HTML.__apply_template(template, vars)
		result = ""

		while /^(.*?)(\$\{[0-9a-zA-Z_]+\})(.*)$/ =~ template
			left = $1
			attr_name = $2
			template = $3

			result << left
			if vars[attr_name] != nil then
				result << vars[attr_name]
			end
		end

		result << template

		return result
	end

end
