# coding: UTF-8

require 'm2w_command'
require 'm2w_mail_parser'
require 'm2w_mail_sender'
require 'm2w_plugin_manager'
require 'mui/mail_command_processor'

class Mail2WeblogRunner

	attr_reader :mail_parser
	attr_reader :mail_sender
	attr_reader :mail_command_processor

	def initialize(
			weblog_extension = M2W_WEBLOG_EXTENSION,
			mail_parser = nil,
			mail_sender = nil,
			mail_command_processor = nil,
			plugin_manager = Mail2WeblogPluginManager.new(M2W_COMMAND_PLUGIN_CONF, M2W_FORMAT_PLUGIN_CONF, M2W_WEBLOG_PLUGIN_CONF),
			processing_time = M2W_SYSTEM_PROCESSING_TIME,
			logger = nil
			)
		if mail_parser == nil then
			@mail_parser = Mail2WeblogMailParser.new(
				M2W_SUBJECT_HEADER,
				M2W_SUBJECT_SEPARATOR_REGEX,
				{})
		else
			@mail_parser = mail_parser
		end

		if mail_sender == nil then
			@mail_sender = Mail2WeblogMailSender.new(
				M2W_SMTP_SERVER_ADDRESS,
				M2W_SMTP_SERVER_PORT,
				M2W_SMTP_SECURITY_TYPE,
				M2W_SMTP_SERVER_USER,
				M2W_SMTP_SERVER_PASSWORD,
				M2W_POP3_BEFORE_SMTP_SERVER_ADDRESS,
				M2W_POP3_BEFORE_SMTP_SERVER_PORT,
				M2W_POP3_BEFORE_SMTP_SERVER_USER,
				M2W_POP3_BEFORE_SMTP_SERVER_PASSWORD,
				M2W_SUBJECT_HEADER,
				M2W_SUBJECT_SEPARATOR,
				MailProcessor.parse_mail_address(M2W_REPLY_ADDRESS),
				M2W_REPLY,
				M2W_LOGGER)
			@mail_sender.enable_ssl_smtp if M2W_SMTP_SERVER_ENABLE_SSL
			@mail_sender.enable_ssl_pop3_before_smtp(OpenSSL::SSL::VERIFY_NONE) if M2W_POP3_BEFORE_SMTP_SERVER_ENABLE_SSL
		else
			@mail_sender = mail_sender
		end
		@mail_sender.logger = logger if logger

		if mail_command_processor == nil then
			@mail_command_processor = MailCommandProcessor.new(
				M2W_POP3_SERVER_ADDRESS,
				M2W_POP3_SERVER_PORT,
				M2W_POP3_SERVER_USER,
				M2W_POP3_SERVER_PASSWORD,
				M2W_LOGGER)
			@mail_command_processor.enable_ssl(OpenSSL::SSL::VERIFY_NONE) if M2W_POP3_SERVER_ENABLE_SSL
		else
			@mail_command_processor = mail_command_processor
		end
		@mail_command_processor.logger = logger if logger

		@mail_command = Mail2WeblogCommand.new(
			weblog_extension,
			@mail_parser,
			@mail_sender,
			plugin_manager,
			processing_time,
			M2W_LOGGER)
		@mail_command.logger = logger if logger
		@mail_command_processor.command = @mail_command

		@processing_time = processing_time
	end

	def run(continuous_processing, mail_receiver_sleep_time)
		@mail_command.start_time = Time.now.to_i

		while true
			@mail_command_processor.run

			if !(continuous_processing && @processing_time >= 0 && @processing_time >= Time.now.to_i - start_time) then
				break
			end

			if continuous_processing && @processing_time >= 0 && mail_receiver_sleep_time >= 0 then
				sleep(mail_receiver_sleep_time)
			end
		end
	end

end
