#!ruby
# coding: UTF-8

require 'cgi'
require 'yaml'

cgi = CGI.new

TRACKBACK_LOG_FILENAME = 'trackback.log'

trackbacks = []
if File.exist?(TRACKBACK_LOG_FILENAME) then
	trackbacks = open(TRACKBACK_LOG_FILENAME, 'r') do |file|
		YAML.load(file)
	end
end

trackback = {}
cgi.keys.each do |key|
	trackback[key] = cgi[key].to_s
end

trackbacks.push(trackback)
open(TRACKBACK_LOG_FILENAME, 'w') do |file|
	YAML.dump(trackbacks, file)
end

puts <<END_CONTENT
Content-Type: application/xml;

<?xml version="1.0" encoding="iso-8859-1"?>
<response>
<error>0</error>
</response>
END_CONTENT
