# coding: UTF-8

ROOT_PATH = File.dirname(File.expand_path(__FILE__))

$:.unshift(ROOT_PATH + '/')
$:.unshift(ROOT_PATH + '/../../')
$:.unshift(ROOT_PATH + '/../../../main/')
$:.unshift(ROOT_PATH + '/../../../main/lib')

# mail2weblog のルートパスを設定する
M2W_ROOT_PATH = ROOT_PATH + '/../../../main/'

require 'm2w_configurator'
require 'plugin/format/lib/format_plugin_utils'

require 'minitest/unit'

MiniTest::Unit.autorun

#=書式プラグインユーティリティーのテスト
#
# 最初の著者:: トゥイー
# リポジトリ情報:: $Id: test_format_plugin_utils.rb 587 2012-03-11 11:43:21Z banana_king $
# 著作権:: Copyright (C) Ownway.info, 2011. All rights reserved.
# ライセンス:: CPL(Common Public Licence)
class TestFormatPluginUtils < MiniTest::Unit::TestCase
	include FormatPluginUtils

	def test_format_plugin_common_conf
		assert_equal '/', format_plugin_common_conf({}, M2W_FORMAT_PLUGIN_COMMON_CONF_PARAM_SEPARATOR_NAME)
		assert_equal '@', format_plugin_common_conf({}, M2W_FORMAT_PLUGIN_COMMON_CONF_OPTION_SEPARATOR_NAME)
		assert_equal '"', format_plugin_common_conf({}, M2W_FORMAT_PLUGIN_COMMON_CONF_QUOTE_CHAR_NAME)

		assert_equal ',', format_plugin_common_conf({M2W_FORMAT_PLUGIN_COMMON_CONF_NAME => {
			M2W_FORMAT_PLUGIN_COMMON_CONF_PARAM_SEPARATOR_NAME => ','
		}}, M2W_FORMAT_PLUGIN_COMMON_CONF_PARAM_SEPARATOR_NAME)

		assert_equal '=', format_plugin_common_conf({M2W_FORMAT_PLUGIN_COMMON_CONF_NAME => {
			M2W_FORMAT_PLUGIN_COMMON_CONF_OPTION_SEPARATOR_NAME => '='
		}}, M2W_FORMAT_PLUGIN_COMMON_CONF_OPTION_SEPARATOR_NAME)

		assert_equal "'", format_plugin_common_conf({M2W_FORMAT_PLUGIN_COMMON_CONF_NAME => {
			M2W_FORMAT_PLUGIN_COMMON_CONF_QUOTE_CHAR_NAME => "'"
		}}, M2W_FORMAT_PLUGIN_COMMON_CONF_QUOTE_CHAR_NAME)
	end

	def test_parse_csv
		result = __parse_csv('value1,value2,value3', ',', '"')
		assert_equal 3, result.size
		assert_equal 'value1', result[0]
		assert_equal 'value2', result[1]
		assert_equal 'value3', result[2]

		result = __parse_csv('value1,"value2,value3",value4', ',', '"')
		assert_equal 3, result.size
		assert_equal 'value1', result[0]
		assert_equal 'value2,value3', result[1]
		assert_equal 'value4', result[2]

		result = __parse_csv('value1,"""value2"",""value3""",value4', ',', '"')
		assert_equal 3, result.size
		assert_equal 'value1', result[0]
		assert_equal '"value2","value3"', result[1]
		assert_equal 'value4', result[2]

		result = __parse_csv('value1,value2"value3', ',', '"')
		assert_equal 2, result.size
		assert_equal 'value1', result[0]
		assert_equal 'value2"value3', result[1]

		assert_raises(FormatPluginError) do
			__parse_csv('value1,"value2', ',', '"')
		end

		assert_raises(FormatPluginError) do
			__parse_csv('value1,"value2"value3', ',', '"')
		end

		result = __parse_csv("value1/'value2/value3'/value4", '/', "'")
		assert_equal 3, result.size
		assert_equal 'value1', result[0]
		assert_equal 'value2/value3', result[1]
		assert_equal 'value4', result[2]
	end

	def test_get_option
		option = __get_option(['attr1@value1', 'attr2@value2'], {})
		assert_equal 2, option.size
		assert_equal 'value1', option['attr1']
		assert_equal 'value2', option['attr2']

		option = __get_option([], {})
		assert_equal 0, option.size

		option = __get_option(['attr1@value1', 'attr2@value2@value3'], {})
		assert_equal 2, option.size
		assert_equal 'value1', option['attr1']
		assert_equal 'value2@value3', option['attr2']

		option = __get_option(
			['attr1=value1', 'attr2=value2'],
			{M2W_FORMAT_PLUGIN_COMMON_CONF_NAME => {
				M2W_FORMAT_PLUGIN_COMMON_CONF_OPTION_SEPARATOR_NAME => '=',
			}
		})
		assert_equal 2, option.size
		assert_equal 'value1', option['attr1']
		assert_equal 'value2', option['attr2']
	end

	def test_parse_param
		(params, option) = __parse_param('param1/param2', {}, 2)
		assert_equal 2, params.size
		assert_equal 'param1', params[0]
		assert_equal 'param2', params[1]
		assert_equal 0, option.size

		(params, option) = __parse_param('param1/"param2"/attr1@value1/"attr2@value2/attr3@value3"', {}, 2)
		assert_equal 2, params.size
		assert_equal 'param1', params[0]
		assert_equal 'param2', params[1]
		assert_equal 2, option.size
		assert_equal 'value1', option['attr1']
		assert_equal 'value2/attr3@value3', option['attr2']

		assert_raises(FormatPluginError) do
			__parse_param('param1', {}, 2)
		end

		(params, option) = __parse_param("param1,'param2',attr1=value1,'attr2=value2,attr3=value3'", {
			M2W_FORMAT_PLUGIN_COMMON_CONF_NAME => {
				M2W_FORMAT_PLUGIN_COMMON_CONF_PARAM_SEPARATOR_NAME => ',',
				M2W_FORMAT_PLUGIN_COMMON_CONF_OPTION_SEPARATOR_NAME => '=',
				M2W_FORMAT_PLUGIN_COMMON_CONF_QUOTE_CHAR_NAME => "'",
			},
		}, 2)
		assert_equal 2, params.size
		assert_equal 'param1', params[0]
		assert_equal 'param2', params[1]
		assert_equal 2, option.size
		assert_equal 'value1', option['attr1']
		assert_equal 'value2,attr3=value3', option['attr2']
	end

	def test_get_format_plugin_parameter
		(params, option, content) = get_format_plugin_parameter('param1/param2', {}, 2)
		assert_equal 2, params.size
		assert_equal 'param1', params[0]
		assert_equal 'param2', params[1]
		assert_equal 0, option.size
		assert_nil content

		(params, option, content) = get_format_plugin_parameter('param1/"param2"/attr1@value1/"attr2@value2/attr3@value3"', {}, 2)
		assert_equal 2, params.size
		assert_equal 'param1', params[0]
		assert_equal 'param2', params[1]
		assert_equal 2, option.size
		assert_equal 'value1', option['attr1']
		assert_equal 'value2/attr3@value3', option['attr2']
		assert_nil content

		assert_raises(FormatPluginError) do
			get_format_plugin_parameter('param1', {}, 2)
		end

		(params, option, content) = get_format_plugin_parameter("param1,'param2',attr1=value1,'attr2=value2,attr3=value3'", {
			M2W_FORMAT_PLUGIN_COMMON_CONF_NAME => {
				M2W_FORMAT_PLUGIN_COMMON_CONF_PARAM_SEPARATOR_NAME => ',',
				M2W_FORMAT_PLUGIN_COMMON_CONF_OPTION_SEPARATOR_NAME => '=',
				M2W_FORMAT_PLUGIN_COMMON_CONF_QUOTE_CHAR_NAME => "'",
			},
		}, 2)
		assert_equal 2, params.size
		assert_equal 'param1', params[0]
		assert_equal 'param2', params[1]
		assert_equal 2, option.size
		assert_equal 'value1', option['attr1']
		assert_equal 'value2,attr3=value3', option['attr2']
		assert_nil content

		(params, option, content) = get_format_plugin_parameter("param1/param2/attr1@value1/a2@value2\ncontent1\ncontent2", {}, 2, {'a2' => 'attr2'})
		assert_equal 2, params.size
		assert_equal 'param1', params[0]
		assert_equal 'param2', params[1]
		assert_equal 2, option.size
		assert_equal 'value1', option['attr1']
		assert_equal 'value2', option['attr2']
		assert_equal "content1\ncontent2", content

		(params, option, content) = get_format_plugin_parameter(
			# プラグイン指定
			"a04@v04/a07@v07/a09@v09/a10@v10/a12@v12/a13@v13/a14@v14/a15@v15", {
				M2W_FORMAT_PLUGIN_CONF_NAME => {
					M2W_FORMAT_PLUGIN_NAME => 'example',
					# プラグイン設定値
					'a02' => 'v02_conf',
					'a05' => 'v05_conf',
					'a08' => 'v08_conf',
					'a09' => 'v09_conf',
					'a11' => 'v11_conf',
					'a12' => 'v12_conf',
					'a14' => 'v14_conf',
					'a15' => 'v15_conf',
				},
				# ヘッダー指定
				M2W_FORMAT_PLUGIN_CONF_HEADER_NAME => {
					'example' => 'a03@v03_example/a06@v06_example/a08@v08_example/a09@v09_example/a11@v11_example/a13@v13_example/a14@v14_example/a15@v15_example',
				},
			}, 0, {
				# エイリアス
				'a01' => 'attr01',
				'a02' => 'attr02',
				'a03' => 'attr03',
				'a04' => 'attr04',
				'a05' => 'attr05',
				'a06' => 'attr06',
				'a07' => 'attr07',
				'a08' => 'attr08',
				'a09' => 'attr09',
				'a10' => 'attr10',
				'a11' => 'attr11',
				'a12' => 'attr12',
				'a13' => 'attr13',
				'a14' => 'attr14',
				'a15' => 'attr15',
			}, {
				# デフォルト値
				'a01' => 'v01_default',
				'a05' => 'v05_default',
				'a06' => 'v06_default',
				'a07' => 'v07_default',
				'a11' => 'v11_default',
				'a12' => 'v12_default',
				'a13' => 'v13_default',
				'a15' => 'v15_default',
			}
		)
		assert_equal 0, params.size
		assert_equal 15, option.size, option.to_s
		assert_equal 'v01_default', option['attr01']
		assert_equal 'v02_conf'   , option['attr02']
		assert_equal 'v03_example', option['attr03']
		assert_equal 'v04'        , option['attr04']
		assert_equal 'v05_conf'   , option['attr05']
		assert_equal 'v06_example', option['attr06']
		assert_equal 'v07'        , option['attr07']
		assert_equal 'v08_example', option['attr08']
		assert_equal 'v09'        , option['attr09']
		assert_equal 'v10'        , option['attr10']
		assert_equal 'v11_example', option['attr11']
		assert_equal 'v12'        , option['attr12']
		assert_equal 'v13'        , option['attr13']
		assert_equal 'v14'        , option['attr14']
		assert_equal 'v15'        , option['attr15']
		assert_nil content

		(params, option, content) = get_format_plugin_parameter(
			# プラグイン指定
			"!a01", {
				M2W_FORMAT_PLUGIN_CONF_NAME => {
					M2W_FORMAT_PLUGIN_NAME => 'example',
					# プラグイン設定値
					'!a03' => nil,
				},
				# ヘッダー指定
				M2W_FORMAT_PLUGIN_CONF_HEADER_NAME => {
					'example' => '!a02',
				},
			}, 0, {
				# エイリアス
				'a01' => 'attr01',
				'a02' => 'attr02',
				'a03' => 'attr03',
			}, {
				# デフォルト値
				'a01' => 'v01_default',
				'a02' => 'v02_default',
				'a03' => 'v03_default',
			}
		)
		assert_equal 0, params.size
		assert_equal 0, option.size, option.to_s
		assert_nil content
	end

	def test_get_format_plugin_parameter4multiline
expected_content = <<"END_CONTENT"
line1
line2

line4
line5
END_CONTENT

param = <<"END_CONTENT"
param1/param2/attr1@value1/attr2@value2
line1
line2

line4
line5
END_CONTENT

		(params, option, content) = get_format_plugin_parameter(param, {}, 2)
		assert_equal 2, params.size
		assert_equal 'param1', params[0]
		assert_equal 'param2', params[1]
		assert_equal 2, option.size
		assert_equal 'value1', option['attr1']
		assert_equal 'value2', option['attr2']
		assert_equal expected_content, content
	end

	def test_apply_template

	end

	def test_marge_custom_template
		
	end
end
