<?php

/**
 * data_clumpとRDBハンドルとを紐付けるクラス
 *
 * @package magicweapon
 * @link http://www.grid-works-guild.net/MagicWeapon/ MagicWeapon
 * @access  public
 * @author  Michiaki Wuzawa <wuzawa@m-fr.net>
 * @create  $LastChangedDate$
 * @version $Revision$
 */

require_once('data_clump_adaptor_base.inc');

class data_clump_rdb_adaptor extends data_clump_adaptor_base
{

/**
 * create用処理
 *
 * @access public
 * @param data_clump_obj $clump 対象data_clumpインスタンス
 * @return boolean
 */
public function create($clump)
{
  // 全データの格納
  $value = array();
  foreach($clump->get_all_names() as $name) {
    $value[ $clump->get_db_name($name) ] = $clump->get_data($name);
  }

  // SQLの作成
  $sql = sql_util::make_insert($clump->get_table_name(), $value);

  // SQLの発行依頼
  $ret = $this->_sql($sql, 'write', $clump->get_identifier());
//print "db insert is\n";
//var_dump($ret);

  // XXX ちょいと雑
  return !(is_null($ret));
}


/**
 * pkを使ったread
 *
 * @access public
 * @param data_clump_obj $clump 対象data_clumpインスタンス
 * @return boolean
 */
public function read_pk($clump)
{
  // WHERE句用配列の作成
  $where = $this->_make_where($clump);

  // 実働依頼
  return $this->_read($clump, $where);
}


/**
 * pkによらないread
 *
 * @access public
 * @param data_clump_obj $clump 対象data_clumpインスタンス
 * @return boolean
 */
public function read_nopk($clump)
{
  // WHERE句用配列の作成
  $cols = $clump->get_all_names();

  // 値があるものをandでwhereとする
  $where = array();
  foreach ($cols as $col) {
    //
    if ("" !== $clump->get_value($col)) {
      $where[$col] = $clump->get_value($col);
    }
  }

  // 実働依頼
  return $this->_read($clump, $where);
}


/**
 * 全体update用処理
 *
 * @access public
 * @param data_clump_obj $clump 対象data_clumpインスタンス
 * @return boolean
 */
public function update_all($clump)
{
  // value部分の設定
  $values = array();
  foreach($clump->get_all_no_key_names() as $name) {
    $values[ $clump->get_db_name($name) ] = $clump->get_data($name);
  }

  // 後はおまかせ
  return $this->_update($clump, $values);
}


/**
 * 部分的なupdate用処理
 *
 * @access public
 * @param data_clump_obj $clump 対象data_clumpインスタンス
 * @return boolean
 */
public function update_mono($clump)
{
  // value部分の設定
  $values = array();
  foreach($clump->get_mono_set_db_target() as $name) {
    $values[ $clump->get_db_name($name) ] = $clump->get_data($name);
  }

  // 後はおまかせ
  return $this->_update($clump, $values);
}

/**
 * 更新処理
 *
 * insertまたはupdate
 *
 * @access public
 * @param data_clump_obj $clump 対象data_clumpインスタンス
 * @param array $targets 更新対象カラム名の配列
 * @return boolean
 */
public function set($clump){
  // insertしてみて
  $ret = $this->create($clump);
  if (true === $ret) {
    return true;
  }

  // NGならupdateしてみる
  // XXX 判定ちょいと雑
  return $this->update_all($clump);
}

/**
 * 削除用処理
 *
 * @access public
 * @param data_clump_obj $clump 対象data_clumpインスタンス
 * @param array $targets 更新対象カラム名の配列
 * @return boolean
 */
public function delete($clump)
{
  // deleteテーブル用のinsertを独自発行～
  // XXX createと処理ほとんど一緒なんだけどねぇ…とりあえず共通化はしないっつか悩んでる
  // --------------------------------------------

  // 全データの格納
  $value = array();
  foreach($clump->get_all_names() as $name) {
    $value[ $clump->get_db_name($name) ] = $clump->get_data($name);
  }
  // 削除日の格納
  $value['delete_date'] = calendar_util::get_now_string();

  // SQLの作成
  $sql = sql_util::make_insert($clump->get_table_name() . '_delete', $value);

  // SQLの発行依頼
  $this->_sql($sql, 'write', $clump->get_identifier());


  // 実際の削除処理
  // --------------------------------------------

  // WHERE句用配列の作成
  $where = $this->_make_where($clump);

  // SQLの作成
  $sql = sql_util::make_delete($clump->get_table_name(), $where);

  // SQLの発行依頼
  $ret = $this->_sql($sql, 'write', $clump->get_identifier());

  // XXX ちょいと雑
  return !(is_null($ret));
}



/**
 * SQL発行処理
 *
 * @access protected
 * @param string $sql SQL
 * @return object エラーだったときはNULL
 */
protected function _sql($sql, $mode, $identifier_name)
{
  //
  if (true === $this->get_data_handle()->is_mono_rdb()) {
    $r = $this->get_data_handle()->query($sql);
  } else {
    $r = $this->get_data_handle()->query_to_specified_handle($sql, $mode, $identifier_name);
  }
  return $r;
}


/**
 * pkによるwhere句(用の配列)の作成
 *
 * @access protected
 * @param data_clump_obj $clump 対象data_clumpインスタンス
 * @return boolean
 */
protected function _make_where($clump)
{
  $where = array();
  foreach($clump->get_all_key_names() as $name) {
    $where[ $clump->get_db_name($name) ] = $clump->get_data($name);
  }
  //
  return $where;
}


/**
 * readの実態
 *
 * @access protected
 * @param data_clump_obj $clump 対象data_clumpインスタンス
 * @param array $where where句作成用配列
 * @return boolean
 */
protected function _read($clump, $where)
{
  // SELECT カラムの作成
  $col_array = array();
  $awk = $clump->get_all_names();
  // DB名に変更
  foreach($awk as $wk) {
    $col_array[] = $clump->get_db_name($wk);
  }
  $col = implode(",", $col_array);

  // SQLの作成
  $sql = "SELECT " . $col . " FROM " . $clump->get_table_name() . " WHERE " . sql_util::make_where($where) . ";";
//print "<br>" . $sql . "<br>\n";

  // SQLの発行依頼
  $res = $this->_sql($sql, 'read', $clump->get_identifier());
  // SQLの発行でこけたっぽいならNG
  if (true === is_null($res)) {
    return false;
  }

  // データがなければNG
  if (false === $res->fetch()) {
    return false;
  }

  // データの設定
  $count = 0;
  foreach($clump->get_all_names() as $name) {
//print "Trap2 <br />\n";
    // データをインスタンス内に保持
    $clump->set_value($name, $res->get_data($count), false);
//print "$name is " . $res->get_data($count) . "\n";

    //
    $count ++;
  }

  //
  return true;
}


/**
 * update用処理本体
 *
 * @access protected
 * @param data_clump_obj $clump 対象data_clumpインスタンス
 * @param array $values 更新対象のデータ一式
 * @return boolean
 */
protected function _update($clump, $values)
{
  // WHERE句用配列の作成
  $where = $this->_make_where($clump);

  // SQLの作成
  $sql = sql_util::make_update($clump->get_table_name(), $values, $where);

  // SQLの発行依頼
  $ret = $this->_sql($sql, 'write', $clump->get_identifier());
//print "db update is\n";
//var_dump($ret);

  // XXX ちょいと雑
  return !(is_null($ret));
}


} // end of class
