﻿using System;
using System.Linq;
using System.Text.RegularExpressions;
using System.Windows.Forms;

namespace Aqua877.WinApp.IronLivetube
{
	public partial class SettingsWindow : Form
	{
		private LivetubeCommentReader LivetubeData;

		public SettingsWindow(LivetubeCommentReader data)
		{
			this.LivetubeData = data;

			this.InitializeComponent();

			#region 基本タブの内容の初期化
			if (GlobalValues.Setting.LivetubeUserID != "" && GlobalValues.Setting.LivetubePassword != "")
			{
				this.LivetubeUserIDTextBox.ReadOnly = true;
				this.LivetubeUserIDTextBox.Text = GlobalValues.Setting.LivetubeUserID;
				this.LivetubePasswordTextBox.ReadOnly = true;
				this.LivetubePasswordTextBox.Text = GlobalValues.Setting.LivetubePassword;

				this.LivetubeIsLoggedLabel.Text = "認証済み";
				this.LivetubeLoginButton.Enabled = false;
			}
			else
			{
				this.LivetubeIsLoggedLabel.Text = "未認証";
				this.LivetubeLogoffButton.Enabled = false;
			}

			if (GlobalValues.Setting.IsPlayNotifySound)
			{
				this.IsPlayNotifySoundCheckBox.Checked = GlobalValues.Setting.IsPlayNotifySound;
				this.SoundFilePathTextBox.Text = GlobalValues.Setting.NotifySoundPath;
				this.ReferSoundFilePathButton.Enabled = true;
			}
			else
			{
				this.ReferSoundFilePathButton.Enabled = false;
			}

			this.ShowCommentAnchorCheckBox.Checked = GlobalValues.Setting.IsShowCommentAnchor;

			if (GlobalValues.Setting.IsShowAllComments)
			{
				this.ShowAllCommentsCheckBox.Checked = GlobalValues.Setting.IsShowAllComments;
				this.ShowCommentCountTextBox.Enabled = false;
			}
			else
			{
				this.ShowCommentCountTextBox.Value = GlobalValues.Setting.ShowCommentCount;
			}

			if (GlobalValues.Setting.IsSelectServer)
			{
				this.SelectServerCheckBox.Checked = GlobalValues.Setting.IsSelectServer;

				switch (GlobalValues.Setting.SelectedServer)
				{
					case LivetubeServers.Default:
					{
						this.ServerListComboBox.Text = "livetube.cc";
						break;
					}

					case LivetubeServers.H:
					{
						this.ServerListComboBox.Text = "h.livetube.cc";
						break;
					}

					case LivetubeServers.Large03:
					{
						this.ServerListComboBox.Text = "large03.livetube.cc";
						break;
					}

					case LivetubeServers.Large04:
					{
						this.ServerListComboBox.Text = "large04.livetube.cc";
						break;
					}

					case LivetubeServers.Large05:
					{
						this.ServerListComboBox.Text = "large05.livetube.cc";
						break;
					}

					case LivetubeServers.Tes01:
					{
						this.ServerListComboBox.Text = "tes01.livetube.cc";
						break;
					}
				}
			}
			else
			{
				this.ServerListComboBox.Enabled = false;
			}

			this.IsUseShortenURLSiteCheckBox.Checked = GlobalValues.Setting.IsUseShortenURLSite;
			#endregion

			#region 表示タブの内容の初期化
			this.IsShowWindowMostTopCheckBox.Checked = GlobalValues.Setting.IsShowWindowMostTop;

			this.IsEnableSemitransparentModeCheckBox.Checked = GlobalValues.Setting.IsEnableSemitransparentMode;

			this.IsEnablePutWindowIntoTaskTrayCheckBox.Checked = GlobalValues.Setting.IsEnablePutWindowIntoTaskTrayCheckBox;

			this.IsLockSortOrderCheckBox.Checked = GlobalValues.Setting.IsLockSortOrder;

			this.SortOrderTextBox.Text =
				(GlobalValues.Setting.CommentsSortOrder == SortOrder.Ascending) ? "昇順" : "降順";

			this.IsShowGridLineCheckBox.Checked = GlobalValues.Setting.IsShowGridLines;

			this.IsEnableAutoScrollCheckBox.Checked = GlobalValues.Setting.IsEnableAutoScroll;
			#endregion

			#region コマンドタブの内容の初期化
			if (GlobalValues.Setting.IsEnableCommand)
			{
				this.CommandsGroupBox.Enabled = true;
				this.IsEnableCommandsCheckBox.Checked = true;
			}
			else
			{
				this.CommandsGroupBox.Enabled = false;
				this.IsEnableCommandsCheckBox.Checked = false;
			}

			#endregion

			#region 朗読設定タブの内容の初期化
			if (GlobalValues.Setting.IsEnableReading)
			{
				this.IsEnableReadingCheckBox.Checked = true;
			}
			else
			{
				this.IsEnableReadingCheckBox.Checked = false;
				this.groupBox4.Enabled = false;
			}

			this.SoftalkPathTextBox.Text = GlobalValues.Setting.SoftalkPath;

			this.ReadingTemplateTextBox.Text = GlobalValues.Setting.ReadingTemplate;

			this.ReplacementWordsListView.Items.AddRange(
				GlobalValues.Setting.ReplacementWords.Select(
					r => new ListViewItem(new string[]
						{
							r.Before,
							r.After,
							r.AddedByUser ? "ユーザー" : "コメント",
							r.ReplacementTarget == MatchTarget.All ? "全体" : r.ReplacementTarget == MatchTarget.ToText ? "コメント本文" : "本文以外",
							r.IsUseRegex ? "使用" : "不使用"
						}
					)
				).ToArray()
			);

			this.IsReadCommentAtFirstCheckBox.Checked = GlobalValues.Setting.IsReadCommentAtFirst;
			this.IsEnableAdjustReadSpeedCheckBox.Checked = GlobalValues.Setting.IsEnableAdjustReadSpeed;
			#endregion

			#region 効果音設定タブの内容の初期化
			if (GlobalValues.Setting.IsEnableSoundEffect)
			{
				this.IsPlaySoundEffectCheckBox.Checked = true;
			}
			else
			{
				this.IsPlaySoundEffectCheckBox.Checked = false;
				this.groupBox6.Enabled = false;
			}

			this.SoundEffectRulesListView.Items.AddRange(
				GlobalValues.Setting.SoundEffectRules.Select(
					r => new ListViewItem(new string[]
						{
							r.PlaySoundEffectCondition,
							r.SoundFilePath,
							r.ExactMatch ? "完全一致" : "部分一致"
						}
					)
				).ToArray()
			);
				
			#endregion

			#region NGワードタブの内容の初期化
			if (GlobalValues.Setting.IsEnableFiltering)
			{
				this.IsEnableFilteringCheckBox.Checked = true;
			}
			else
			{
				this.IsEnableFilteringCheckBox.Checked = false;
				this.groupBox5.Enabled = false;
			}

			this.FilteringRulesListView.Items.AddRange(
				GlobalValues.Setting.FilteringRules.Select(
					r => new ListViewItem(new string[]
						{
  							r.Rule,
							r.IsEnableAutoBan ? "有効" : "無効",
							r.IsEnableAutoUnBan ? "有効" : "無効",
							r.IsEnableAutoUnBan ? r.UnBanDelayCount.ToString() : "(なし)",
							r.AddedByUser ? "ユーザー" : "コメント",
							r.FilteringTarget == MatchTarget.All ? "全体" : r.FilteringTarget == MatchTarget.ToText ? "コメント本文" : "本文以外",
							r.IsUseRegularExpression ? "使用" : "不使用"
						}
					)
				).ToArray()
			);
	
			this.IsExceptMatchedCommentCheckBox.Checked = GlobalValues.Setting.IsExceptMatchedComment;
			#endregion
		}

		#region 基本タブのイベント
		private void LivetubeLoginButton_Click(object sender, EventArgs e)
		{
			if (this.LivetubeUserIDTextBox.Text == "")
			{
				this.LivetubeCredentialErrorLabel.Visible = true;
				this.LivetubeCredentialErrorLabel.Text = "    ユーザーIDが入力されていません";
				return;
			}

			if (this.LivetubePasswordTextBox.Text == "")
			{
				this.LivetubeCredentialErrorLabel.Visible = true;
				this.LivetubeCredentialErrorLabel.Text = "    パスワードが入力されていません";
				return;
			}

			Action<bool, Exception> finishedLoginCallBack = null;
			finishedLoginCallBack = (success, error) =>
			{
				if (!success)
				{
					this.LivetubeCredentialErrorLabel.Visible = true;
					this.LivetubeCredentialErrorLabel.Text = "   " + error.Message;
				}
				else
				{
					this.LivetubeUserIDTextBox.ReadOnly = true;
					GlobalValues.Setting.LivetubeUserID = this.LivetubeUserIDTextBox.Text;
					this.LivetubePasswordTextBox.ReadOnly = true;
					GlobalValues.Setting.LivetubePassword = this.LivetubePasswordTextBox.Text;
					this.LivetubeIsLoggedLabel.Text = "認証済み";
					this.LivetubeLoginButton.Enabled = false;
					this.LivetubeLogoffButton.Enabled = true;

					this.LivetubeCredentialErrorLabel.Visible = false;
				}
				this.LivetubeData.OnLoginFinished -= finishedLoginCallBack;
			};

			this.LivetubeData.OnLoginFinished += finishedLoginCallBack;
			this.LivetubeData.LoginAsync(this.LivetubeUserIDTextBox.Text, this.LivetubePasswordTextBox.Text);
		}

		private void LivetubeLogoffButton_Click(object sender, EventArgs e)
		{
			this.LivetubeUserIDTextBox.ReadOnly = false;
			this.LivetubeUserIDTextBox.Text = "";
			this.LivetubePasswordTextBox.ReadOnly = false;
			this.LivetubePasswordTextBox.Text = "";
			this.LivetubeIsLoggedLabel.Text = "未認証";
			this.LivetubeLoginButton.Enabled = true;
			this.LivetubeLogoffButton.Enabled = false;

			this.LivetubeData.Logout();
		}
	
		private void IsPlayNotifySoundCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			GlobalValues.Setting.IsPlayNotifySound = this.IsPlayNotifySoundCheckBox.Checked;

			if (this.IsPlayNotifySoundCheckBox.Checked)
			{
				this.ReferSoundFilePathButton.Enabled = true;
			}
			else
			{
				this.ReferSoundFilePathButton.Enabled = false;
			}
		}

		private void ReferSoundFilePathButton_Click(object sender, EventArgs e)
		{
			var result = this.ReferNotifySoundFilePathDialog.ShowDialog();

			if (result == DialogResult.OK)
			{
				GlobalValues.Setting.NotifySoundPath = this.ReferNotifySoundFilePathDialog.FileName;
				this.SoundFilePathTextBox.Text = this.ReferNotifySoundFilePathDialog.FileName;
			}
			else
			{
				GlobalValues.Setting.NotifySoundPath = "";
				this.SoundFilePathTextBox.Text = "";
			}
		}

		private void ShowCommentAnchorCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			GlobalValues.Setting.IsShowCommentAnchor = this.ShowCommentAnchorCheckBox.Checked;
		}

		private void ShowAllCommentsCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			GlobalValues.Setting.IsShowAllComments = this.ShowAllCommentsCheckBox.Checked;

			if (this.ShowAllCommentsCheckBox.Checked)
			{
				this.ShowCommentCountTextBox.Enabled = false;
			}
			else
			{
				this.ShowCommentCountTextBox.Enabled = true;
			}
		}

		private void ShowCommentCountTextBox_ValueChanged(object sender, EventArgs e)
		{
			GlobalValues.Setting.ShowCommentCount = (int)this.ShowCommentCountTextBox.Value;
		}

		private void SelectServerCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			GlobalValues.Setting.IsSelectServer = this.SelectServerCheckBox.Checked;

			if (this.SelectServerCheckBox.Checked)
			{
				this.ServerListComboBox.Enabled = true;
			}
			else
			{
				this.ServerListComboBox.Enabled = false;
			}
		}

		private void ServerListComboBox_SelectedIndexChanged(object sender, EventArgs e)
		{
			switch (this.ServerListComboBox.Text)
			{
				case "livetube.cc":
				{
					GlobalValues.Setting.SelectedServer = LivetubeServers.Default;
					break;
				}

				case "h.livetube.cc":
				{
					GlobalValues.Setting.SelectedServer = LivetubeServers.H;
					break;
				}

				case "tes01.livetube.cc":
				{
					GlobalValues.Setting.SelectedServer = LivetubeServers.Tes01;
					break;
				}

				case "large03.livetube.cc":
				{
					GlobalValues.Setting.SelectedServer = LivetubeServers.Large03;
					break;
				}

				case "large04.livetube.cc":
				{
					GlobalValues.Setting.SelectedServer = LivetubeServers.Large04;
					break;
				}

				case "large05.livetube.cc":
				{
					GlobalValues.Setting.SelectedServer = LivetubeServers.Large05;
					break;
				}
			}
		}
	
		private void IsEnableAutoBanContinuousCommentsCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			GlobalValues.Setting.IsEnableAutoBanContinuousComments = this.IsEnableAutoBanContinuousCommentsCheckBox.Checked;
		}
		#endregion

		#region 表示タブのイベント
		private void IsShowWindowMostTopCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			GlobalValues.Setting.IsShowWindowMostTop = this.IsShowWindowMostTopCheckBox.Checked;
		}

		private void IsEnableSemitransparentModeCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			GlobalValues.Setting.IsEnableSemitransparentMode = this.IsEnableSemitransparentModeCheckBox.Checked;
		}

		private void IsEnablePutWindowIntoTaskTrayCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			GlobalValues.Setting.IsEnablePutWindowIntoTaskTrayCheckBox = this.IsEnablePutWindowIntoTaskTrayCheckBox.Checked;
		}

		private void IsLockSortOrderCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			GlobalValues.Setting.IsLockSortOrder = this.IsLockSortOrderCheckBox.Checked;
		}

		private void SortOrderTextBox_SelectedIndexChanged(object sender, EventArgs e)
		{
			if (this.SortOrderTextBox.Text == "昇順")
			{
				GlobalValues.Setting.CommentsSortOrder = SortOrder.Ascending;
			}
			else if(this.SortOrderTextBox.Text == "降順")
			{
				GlobalValues.Setting.CommentsSortOrder = SortOrder.Descending;
			}
		}

		private void IsShowGridLineCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			GlobalValues.Setting.IsShowGridLines = this.IsShowGridLineCheckBox.Checked;
		}

		private void IsEnableAutoScroll_CheckedChanged(object sender, EventArgs e)
		{
			GlobalValues.Setting.IsEnableAutoScroll = this.IsEnableAutoScrollCheckBox.Checked;
		}
		#endregion

		#region コマンドタブのイベント
		private void IsEnableCommandsCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			GlobalValues.Setting.IsEnableCommand = this.IsEnableCommandsCheckBox.Checked;

			if (this.IsEnableCommandsCheckBox.Checked)
			{
				this.CommandsGroupBox.Enabled = true;
			}
			else
			{
				this.CommandsGroupBox.Enabled = false;
			}
		}

		private void IsUseReplaceCommandCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			GlobalValues.Setting.IsUseReplaceCommand = this.IsUseReplaceCommandCheckBox.Checked;
		}

		private void IsUseUnreplaceCommandCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			GlobalValues.Setting.IsUseUnreplaceCommand = this.IsUseUnreplaceCommandCheckBox.Checked;
		}

		private void ShowReplaceCommandOptionButton_Click(object sender, EventArgs e)
		{
			using (var repWindow = new global::Aqua877.WinApp.IronLivetube.CommandOptionWindows.ReplaceCommandOptionWindow())
			{
				repWindow.ShowDialog();
			}
		}

		private void IsUseVoteBanCommandCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			GlobalValues.Setting.IsUseVoteBanCommand = this.IsUseVoteBanCommandCheckBox.Checked;
		}

		private void IsUseVoteUnBanCommandCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			GlobalValues.Setting.IsUseVoteUnBanCommand = this.IsUseVoteUnBanCommandCheckBox.Checked;
		}

		private void ShowVoteBanCommandOptionButton_Click(object sender, EventArgs e)
		{
			using (var voteBanWindow = new global::Aqua877.WinApp.IronLivetube.CommandOptionWindows.VoteBanCommandOptionWindow())
			{
				voteBanWindow.ShowDialog();
			}
		}

		private void IsUseCancelPlayingSoundCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			GlobalValues.Setting.IsUseCancelPlayingSoundCommand = this.IsUseCancelPlayingSoundCheckBox.Checked;
		}

		private void IsUseAddFilteringRuleCommandCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			GlobalValues.Setting.IsUseAddFilteringRuleCommand = this.IsUseAddFilteringRuleCommandCheckBox.Checked;
		}

		private void IsUseDeleteFilteringRuleCommandCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			GlobalValues.Setting.IsUseRemoveFilteringRuleCommand = this.IsUseDeleteFilteringRuleCommandCheckBox.Checked;
		}
		#endregion


		#region 朗読設定タブのイベント
		private void IsEnableReadingCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			if (this.IsEnableReadingCheckBox.Checked)
			{
				GlobalValues.Setting.IsEnableReading = true;
				this.groupBox4.Enabled = true;
			}
			else
			{
				GlobalValues.Setting.IsEnableReading = false;
				this.groupBox4.Enabled = false;
			}
		}

		private void ReferSoftalkPathButton_Click(object sender, EventArgs e)
		{
			var result = this.ReferSoftalkPathDialog.ShowDialog();

			if (result == DialogResult.OK)
			{
				GlobalValues.Setting.SoftalkPath = this.ReferSoftalkPathDialog.FileName;
				this.SoftalkPathTextBox.Text = this.ReferSoftalkPathDialog.FileName;
			}
			else
			{
				GlobalValues.Setting.SoftalkPath = "";
				this.SoftalkPathTextBox.Text = "";
			}
		}

		private void SetReadingTemplateButton_Click(object sender, EventArgs e)
		{
			GlobalValues.Setting.ReadingTemplate = this.ReadingTemplateTextBox.Text;
		}

		private void AddReplacementWordButton_Click(object sender, EventArgs e)
		{
			if (this.AddReplacementBeforeWordTextBox.Text.Trim() == "" || this.AddReplacementAfterWordTextBox.Text.Trim() == "")
			{
				this.EditingReplacementErrorLabel.Visible = true;
				this.EditingReplacementErrorLabel.Text = "    読み替え前文字列と読み替え後文字列を入力してください。";
				return;
			}

			if (this.IsUseRegularExpressionToAddReplacementWordCheckBox.Checked)
			{
				try
				{
					new Regex(this.AddReplacementBeforeWordTextBox.Text);
					new Regex(this.AddReplacementAfterWordTextBox.Text);
				}
				catch
				{
					this.EditingReplacementErrorLabel.Visible = true;
					this.EditingReplacementErrorLabel.Text = "    入力された正規表現パターンが正しくありません。";
				}
			}

			GlobalValues.Setting.ReplacementWords.Add(
				new Replacement
				{
					Before = this.AddReplacementBeforeWordTextBox.Text,
					After = this.AddReplacementAfterWordTextBox.Text,
					AddedByUser = true,
					ReplacementTarget = (this.ReplacementMatchToAllRadioButton.Checked ? MatchTarget.All : this.ReplacementMatchToTextRadioButton.Checked ? MatchTarget.ToText : MatchTarget.ExceptText),
					IsUseRegex = this.IsUseRegularExpressionToAddReplacementWordCheckBox.Checked,
					IsApplyToListView = this.IsApplyToListViewCheckBox.Checked
				}
			);

			this.ReplacementWordsListView.Items.Add(
				new ListViewItem(
					new string[]
					{
						this.AddReplacementBeforeWordTextBox.Text,
						this.AddReplacementAfterWordTextBox.Text,
						"ユーザー",
						(this.ReplacementMatchToAllRadioButton.Checked ? "全体" : this.ReplacementMatchToTextRadioButton.Checked ? "コメント本文" : "本文以外"),
						(this.IsUseRegularExpressionToAddReplacementWordCheckBox.Checked ? "使用" : "不使用"),
						(this.IsApplyToListViewCheckBox.Checked.ToString())
					}
				)
			);
		}

		private void RemoveReplacementWordButton_Click(object sender, EventArgs e)
		{
			if (this.ReplacementWordsListView.SelectedItems.Count > 0)
			{
				int removeIndex = this.ReplacementWordsListView.SelectedItems[0].Index;
				GlobalValues.Setting.ReplacementWords.RemoveAt(removeIndex);
				this.ReplacementWordsListView.Items.RemoveAt(removeIndex);
			}
		}

		private void IsReadCommentAtFirstCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			GlobalValues.Setting.IsReadCommentAtFirst = this.IsReadCommentAtFirstCheckBox.Checked;
		}

		private void IsEnableAdjustReadSpeedCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			GlobalValues.Setting.IsEnableAdjustReadSpeed = this.IsEnableAdjustReadSpeedCheckBox.Checked;
		}
		#endregion

		#region 効果音設定タブのイベント
		private void IsPlaySoundEffectCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			if (this.IsPlaySoundEffectCheckBox.Checked)
			{
				GlobalValues.Setting.IsEnableSoundEffect = true;
				this.groupBox6.Enabled = true;
			}
			else
			{
				//表のソート対応時には改善が必要
				GlobalValues.Setting.IsEnableSoundEffect = false;
				this.groupBox6.Enabled = false;
			}
		}

		private void ReferSoundEffectPathButton_Click(object sender, EventArgs e)
		{
			var result = this.ReferSoundEffectPathDialog.ShowDialog();

			if (result == DialogResult.OK)
			{
				this.SoundEffectPathTextBox.Text = this.ReferSoundEffectPathDialog.FileName;
			}
			else
			{
				this.SoundEffectPathTextBox.Text = "";
			}
		}

		private void AddSoundEffectRuleButton_Click(object sender, EventArgs e)
		{
			if (this.SoundEffectPathTextBox.Text.Trim() == "" || this.PlaySoundEffectConditionTextBox.Text.Trim() == "")
			{
				this.EditingReplacementErrorLabel.Visible = true;
				this.EditingReplacementErrorLabel.Text = "    効果音の場所と効果音の再生条件を入力してください。";
				return;
			}

			if (this.IsUseRegularExpressionToAddReplacementWordCheckBox.Checked)
			{
				try
				{
					new Regex(this.PlaySoundEffectConditionTextBox.Text);
				}
				catch
				{
					this.EditingSoundEffectSettingErrorLabel.Visible = true;
					this.EditingSoundEffectSettingErrorLabel.Text = "    入力された正規表現パターンが正しくありません。";
				}
			}

			GlobalValues.Setting.SoundEffectRules.Add(
				new SoundEffectRule
				{
					SoundFilePath = this.SoundEffectPathTextBox.Text,
					PlaySoundEffectCondition = this.PlaySoundEffectConditionTextBox.Text,
					ExactMatch = this.PartialMatchRadioButton.Checked,
					IsUseRegularExpression = this.IsUseRegularExpressionToPlaySoundEffectCheckBox.Checked
				}
			);

			this.ReplacementWordsListView.Items.Add(
				new ListViewItem(
					new string[]
					{
						this.AddReplacementBeforeWordTextBox.Text,
						this.AddReplacementAfterWordTextBox.Text,
						"ユーザー",
						(this.ReplacementMatchToAllRadioButton.Checked ? "全体" : this.ReplacementMatchToTextRadioButton.Checked ? "コメント本文" : "本文以外"),
						(this.IsUseRegularExpressionToAddReplacementWordCheckBox.Checked ? "使用" : "不使用")
					}
				)
			);
		}

		private void RemoveSoundEffectRuleButton_Click(object sender, EventArgs e)
		{
			if (this.SoundEffectRulesListView.SelectedItems.Count > 0)
			{
				int removeIndex = this.SoundEffectRulesListView.SelectedItems[0].Index;
				GlobalValues.Setting.SoundEffectRules.RemoveAt(removeIndex);
				this.SoundEffectRulesListView.Items.RemoveAt(removeIndex);
			}

		}
		#endregion

		#region NGワードタブのイベント
		private void IsEnableFilteringCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			if (this.IsEnableFilteringCheckBox.Checked)
			{
				GlobalValues.Setting.IsEnableFiltering = true;
				this.groupBox5.Enabled = true;
			}
			else
			{
				GlobalValues.Setting.IsEnableFiltering = false;
				this.groupBox5.Enabled = false;
			}
		}

		private void AddFilteringRuleButton_Click(object sender, EventArgs e)
		{
			if (this.AddFilteringRuleTextBox.Text.Trim() == "")
			{
				this.EditingFilteringRuleErrorLabel.Visible = true;
				this.EditingFilteringRuleErrorLabel.Text = "    NGワードとなる文字列を入力してください。";
				return;
			}

			if (this.IsUseRegularExpressionToAddFilteringRuleCheckBox.Checked)
			{
				try
				{
					new Regex(this.AddFilteringRuleTextBox.Text);
				}
				catch
				{
					this.EditingFilteringRuleErrorLabel.Visible = true;
					this.EditingFilteringRuleErrorLabel.Text = "    入力された正規表現パターンが正しくありません。";
				}
			}

			GlobalValues.Setting.FilteringRules.Add(
				new FilteringRule()
				{
					Rule = this.EditingFilteringRuleErrorLabel.Text,
					IsUseRegularExpression = this.IsUseRegularExpressionToAddFilteringRuleCheckBox.Checked,
					IsEnableAutoBan = this.IsEnableBanAsMatchedCheckBox.Checked,
					IsEnableAutoUnBan = this.IsEnableAutoUnBanCheckBox.Checked,
					UnBanDelayCount = (int)this.DelayUnbanSecondTextBox.Value,
					FilteringTarget = (this.FilteringMatchToAllRadioButton.Checked ? MatchTarget.All : this.FilteringMatchToTextRadioButton.Checked ? MatchTarget.ToText : MatchTarget.ExceptText)
				}
			);

			this.FilteringRulesListView.Items.Add(
				new ListViewItem(
					new string[]
					{
						this.EditingFilteringRuleErrorLabel.Text,
						this.IsEnableBanAsMatchedCheckBox.Checked ? "有効" : "無効",
						this.IsEnableAutoUnBanCheckBox.Checked ? "有効" : "無効",
						this.IsEnableAutoUnBanCheckBox.Checked ? this.DelayUnbanSecondTextBox.Value.ToString() : "(なし)",
						"ユーザー",
						(this.FilteringMatchToAllRadioButton.Checked ? "全体" : this.FilteringMatchToTextRadioButton.Checked ? "コメント本文" : "本文以外"),
						this.IsUseRegularExpressionToPlaySoundEffectCheckBox.Checked ? "使用" : "不使用"
					}
				)
			);
		}

		private void RemoveFilteringRuleButton_Click(object sender, EventArgs e)
		{
			if (this.FilteringRulesListView.SelectedItems.Count > 0)
			{
				int removeIndex = this.FilteringRulesListView.SelectedItems[0].Index;
				GlobalValues.Setting.FilteringRules.RemoveAt(removeIndex);
				this.FilteringRulesListView.Items.RemoveAt(removeIndex);
			}
		}

		private void IsExceptMatchedCommentCheckBox_CheckedChanged(object sender, EventArgs e)
		{
			GlobalValues.Setting.IsExceptMatchedComment = this.IsExceptMatchedCommentCheckBox.Checked;
		}
		#endregion




	}
}
