﻿using System;
using System.Windows.Forms;
using System.Diagnostics;

namespace Aqua877.WinApp.IronLivetube
{
	static class Program
	{
		/// <summary>
		/// アプリケーションのメイン エントリ ポイントです。
		/// </summary>
		[STAThread]
		public static void Main()
		{
			//設定のロード
			GlobalValues.LoadSettings();

			//プログラムの起動
			AppDomain.CurrentDomain.UnhandledException += (s, e) =>
			{
				using (var rw = new ErrorReportWindow(e.ExceptionObject as Exception))
				{
					rw.ShowDialog();
				}
			};
			Application.EnableVisualStyles();
			Application.SetCompatibleTextRenderingDefault(false);
			Application.Run(new MainWindow());

			//設定の保存
			GlobalValues.SaveSettings();

			//プログラムの再起動の必要があれば再起動
			if (GlobalValues.RestartProgramTrigger)
			{
				Process.Start(Application.ExecutablePath);
			}
		}
	}
}
