﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Net;
using System.Text.RegularExpressions;

namespace Aqua877.WinApp.IronLivetube
{
	public class SendersWiki
	{
		public Dictionary<string, Uri> SendersWikiList = new Dictionary<string, Uri>();

		public SendersWiki()
		{
			var connector = new WebClient { Encoding = Encoding.UTF8 };
			connector.DownloadStringCompleted += this.OnFinishedGetSendersWiki;
			connector.DownloadStringAsync(new Uri("http://www30.atwiki.jp/livetube/pages/11.html"));
		}

		private void OnFinishedGetSendersWiki(object sender, DownloadStringCompletedEventArgs e)
		{
			if (e.Error == null)
			{
				var pattern = new Regex("<a href=\"(.*?)\"    title=\"(.*?) \\((?:.*?)\\)\">(?:.*?)</a>");
				this.SendersWikiList = pattern.Matches(e.Result).Cast<Match>()
					.Select(m => new { url = m.Groups[1].Value, sender = m.Groups[2].Value })
					.Distinct(xs => xs.sender)
					.ToDictionary(i => i.sender, i => new Uri(i.url));
			}
		}
	}
}
