﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Xml.Serialization;
using System.IO;

namespace Aqua877.WinApp.IronLivetube
{
	public static class GlobalValues
	{
		public static event Action OnCallCleanCachesCalled;
		public const string LiveUrlPattern = @"http://(tes01.|h.|)livetube\.cc/(.+?)";
		public static string StreamIDPattern = @"[a-z0-9]{13}";
		public const string GetStreamIDPattern = @"http://(?:(?:(?:h|tes01|large03|large04|large05)\.|))livetube.cc/stream/([a-z0-9]{13})";
		public const string ExtractCommentDataPattern =
@"<div style=""background-color: #eee;"">
<div style=""margin-top: 6px;"">(<span style=""float:right;font-size:60%;font-style:italic;"">(.*?)</span>|)
(<img src=""(.*?)"" width=""(.*?)"" height=""(.*?)"" align=""left"" />|)
(.*?) : (<a href=""/(.*?)""><span style=""font-size:1em;color:green; font-weight:bolder;"">(.*?)(<span style=""color:blue;"">(.*?)</span>|)</span></a>|(.*?)|) <span style="""">(.*?)</span><br />
<span style=""font-weight:bold;margin-bottom:0px; padding-bottom:0px;"">(.*?)</span><br clear=""left"" />
</div>
</div>";
		public const string BitLyUserName = "ironlivetube";
		public const string BitLyApiKey = "R_f76fa9cb2519f87a22ffb34e7c59b004";
		public const string PTlApiKey = "c371efed93161dd07388bd0ea671d849abdf7834";

		public static readonly string SettingFilePath = Environment.CurrentDirectory + "\\IronLivetube.config.xml";
		public static readonly string[] SupportedShortenServices = { "bit.ly", "j.mp", "is.gd", "ux.nu", "p.tl" };
		public static Settings Setting = new Settings();
		public static int CachingComments = 0;
		public static int CachingThumbnails = 0;
		public static bool RestartProgramTrigger = false;

		public static void LoadSettings()
		{
			if (File.Exists(SettingFilePath))
			{
				using (var stream = new FileStream(SettingFilePath, FileMode.Open))
				{
					try
					{
						var deserializer = new XmlSerializer(typeof(Settings));
						Setting = deserializer.Deserialize(stream) as Settings;
					}
					catch
					{
						#warning TODO : エラーロギング
					}
				}
			}
		}

		public static void SaveSettings()
		{
			using (var stream = new FileStream(SettingFilePath, FileMode.Create))
			{
				var serializer = new XmlSerializer(typeof(Settings));
				serializer.Serialize(stream, Setting);
			}
		}

		public static void CallCleanCaches()
		{
			if (OnCallCleanCachesCalled != null)
			{
				OnCallCleanCachesCalled();
			}
		}
	}
}
