/**
 * @file  WorkerThreadPool.h
 * @brief [J[Xbhv[NX`.
 *
 * @author JIN
 *
 * Copyright (C) 2009- JIN All rights reserved.
 */
#pragma once

#include "Thread.h"
#include "CriticalSection.h"
#include "WaitableHandle.h"

namespace GenericUtility {

/////////////////////////////////////////////////////////////////////////////

typedef boost::shared_ptr<class CWorkerThread> CWorkerThreadPtr;

/**
 * [J[Xbh.
 */
class CWorkerThread : public boost::enable_shared_from_this<CWorkerThread>
{
public:
	CWorkerThread();
	virtual ~CWorkerThread();

	/**
	 * WuC^[tFCX.
	 */
	class IJob
	{
	public:
		virtual ~IJob() = 0 {}

		/**
		 * Wus.
		 */
		virtual void Execute() = 0;
		/**
		 * WuO[v ID 擾.
		 */
		virtual int GetGroupID() = 0;
	};

	typedef boost::shared_ptr<CEvent> CEventPtr;
	/**
	 * Wu.
	 */
	struct JobInfo {
		/// Wu
		IJob* m_pJob;
		/// WuCxg
		/// sÓAempty ̂ƂΑ݂Ƃ
		/// s݂͑
		/// Wu empty ɂȂ.
		CEventPtr m_Event;

		JobInfo() : m_pJob(NULL) {}
	};

	/// WuR[obN
	typedef
		boost::function<
			IJob* /* Next Job */ (const CWorkerThreadPtr&, IJob*)>
		OnCompleteJobFunc;

	/**
	 * .
	 */
	bool Initialize(OnCompleteJobFunc onCompleteJob);

	/**
	 * Xe[^X.
	 */
	enum Status {
		S_Waiting,		//< ҋ@
		S_Starting,		//< WuJn
		S_Ending,		//< XbhI
		S_Running,		//< Wus
		S_Complete,		//< Wu
	};
	/**
	 * Xe[^X擾.
	 */
	Status GetStatus() const;
	/**
	 * Xe[^X S_Complete ɕύX.
	 * (For CWorkerThreadPool::OnCompleteJob())
	 */
	void SetCompleteStatus_();
	/**
	 * ꂩWu̎s\ǂ擾.
	 * (S_Waiting || S_Complete)
	 */
	bool IsReady() const;

	/**
	 * Wus.
	 */
	bool StartJob(IJob* job);
#if 0
	/**
	 * Wu擾.
	 */
	IJob* GetJob() const;
#endif

	/**
	 * XbhI.
	 * (Jn҂̂Ƃ (!IsRunning() ̂Ƃ) ̂ݗL)
	 */
	bool Stop();

private:
	/**
	 * Xbhs֐.
	 */
	bool ThreadFunc();

	/**
	 * XbhsNX.
	 */
	class ThreadRunner : public CThread::Runnable
	{
	public:
		ThreadRunner();

		/**
		 * CWorkerThread ݒ肷.
		 */
		void SetThread(CWorkerThread* pThread);

		/////////////////////////////////////////////////////////////////////////////
		// Runnable
	public:
		virtual bool Initialize();
		virtual DWORD Run();
		virtual bool Stop();

	public:
		CWorkerThread* m_pThread;
	};

private:
	mutable CCriticalSection m_cs;

	/// Xbhs
	ThreadRunner m_ThreadRunner;
	/// Xbh
	CThread m_Thread;

	/// WuR[obN
	OnCompleteJobFunc m_OnCompleteJob;
	/// Wu (Ǘ͍sȂ)
	IJob* m_pJob;

	/// Xe[^XύXCxg
	CEvent m_evStatus;
	/// Xe[^X
	Status m_Status;
};



/////////////////////////////////////////////////////////////////////////////
/**
 * [J[Xbhv[.
 * Wu̒ŁA[J[Xbhv[ēxgƂ͂łȂ(ēs).
 */
class CWorkerThreadPool
{
public:
	CWorkerThreadPool();
	virtual ~CWorkerThreadPool();

	/**
	 * .
	 */
	bool Initialize(
		/// Xbh
		/// < 0 ̂Ƃ́Agp\ȃvZbTRAĂ
		///    0: RAƓ
		///   -1: RA - 1 (CpɎcĂꍇȂ)
		///   ...
		/// (ŏ 1)
		int nThreads = 0);
	/**
	 * Xbh擾.
	 */
	size_t GetThreadNum() const;

	typedef CWorkerThread::IJob	IJob;
	typedef std::vector<IJob*>	Jobs;

	/**
	 * ҋ@WuL[Zbg.
	 * VWuǉOɌĂԕKv.
	 */
	bool Reset(int nGroupID);
	/**
	 * Wuǉ.
	 * (ǉWu̎Ǘ͌Ăяoōs)
	 */
	bool AddJob(IJob* pJob);

	/**
	 * Cӂ̈̃Wû҂.
	 * JԂĂяoƂ́Ał Wait Ōoꂽ̂͏.
	 */
	bool WaitSingle(int nGroupID, IJob*& pJob);
	/**
	 * ԑ AddJob() Wû҂.
	 * JԂĂяoƂ́Ał Wait Ōoꂽ̂͏.
	 * WaitFirst() JԂĂԂƁAAddJob() ԂŃWuIoł.
	 */
	bool WaitFirst(int nGroupID, IJob*& pJob);
	/**
	 * ׂẴWû҂.
	 * ł Wait Ōoꂽ̂͏.
	 */
	bool WaitAll(
		int nGroupID,
		/// [out] Wu.
		///       NULL ̂Ƃ́Aǂ̃WuԂȂ.
		///       (ׂẴWûŁAȂ͂).
		Jobs* pJobs = NULL);

private:
	/**
	 * AChXbh擾.
	 */
	CWorkerThreadPtr GetIdleThread();

	typedef CWorkerThread::JobInfo JobInfo;
	typedef std::deque<JobInfo> JobInfoQueue;

	/**
	 * WuL[Aw肵WuO[v̍ŏ̃Wu擾.
	 */
	static JobInfoQueue::iterator GetFirstJobInfo(
		JobInfoQueue& queue, int nGroupID);
	/**
	 * WuL[Aw肵WuO[v̍Ō̃Wu擾.
	 */
	static JobInfoQueue::reverse_iterator GetLastJobInfo(
		JobInfoQueue& queue, int nGroupID);

	/**
	 * WuR[obN.
	 */
	IJob* OnCompleteJob(const CWorkerThreadPtr& thread, IJob* pJob);

private:
	mutable CCriticalSection m_cs;

	typedef std::vector<CWorkerThreadPtr> WorkerThreadVec;
	/// ׂẴ[J[Xbh
	WorkerThreadVec m_AllThreads;

	/// ҋ@WuL[
	/// AddJob() ƂA[J[Xbhɋ󂫂Ȃ΂ɒǉ.
	JobInfoQueue m_WaitingJobInfoQueue;

	/// s/WuL[
	/// ŝ̂Ɗ̂̂AAddJob() ꂽԂŊ܂.
	JobInfoQueue m_RunningJobInfoQueue;
};

}	// namespace GenericUtility



// [J[Xbhv[̃VOg`
#define DEFINE_WORKER_THREAD_POOL_SINGLETON(NUM_THREADS, GROUP_ID_TAG_TYPE)					\
/** [J[Xbhv[擾p CriticalSection */											\
CCriticalSection g_csWorkerThreadPool;														\
																							\
/** [J[Xbhv[ (singleton) 擾. */										\
CWorkerThreadPool& GetWorkerThreadPool()													\
{																							\
	CAutoCriticalSection acs(g_csWorkerThreadPool);											\
																							\
	/* [J[Xbhv[ (singleton)  */									\
	static CWorkerThreadPool pool;															\
	static bool bInitialized = false;														\
	if (!bInitialized) {																	\
		VERIFY(pool.Initialize(NUM_THREADS));												\
		bInitialized = true;																\
	}																						\
																							\
	return pool;																			\
}																							\
																							\
/** [J[Xbhv[̃WuO[v ID 擾. */								\
int GetWorkerThreadJobGroupID(GROUP_ID_TAG_TYPE nGroupIDTag = (GROUP_ID_TAG_TYPE)0)			\
{																							\
	/* HACK: WuO[v ID ƂāAXbh ID ƃO[v ID ^OƂ̘_aƂB	*/	\
	/* HACK: Xbh ID ͂܂傫Ȓlɂ͂ȂȂƂ肵āA					*/	\
	/* hACK: O[v ID ^Oɂ͏ʌgp邱ƁB									*/	\
	/* HACK: WuO[v ID ͕̐ɂȂĂ܂ȂB							*/	\
	ASSERT(::GetCurrentThreadId() < 0x00008000);											\
	return ::GetCurrentThreadId() | nGroupIDTag;											\
}																							\
// end of DEFINE_WORKER_THREAD_POOL_SINGLETON
