/**
 * @file  ResizableDialog.h
 * @brief TCYσ_CAO̊{NX.
 *
 * @author JIN
 *
 * Copyright (C) 2007- JIN All rights reserved.
 */
#ifndef RESIZABLEDIALOG_H_
#define RESIZABLEDIALOG_H_

#include "DialogSizeHelper.h"
#include "MessageMap.h"

namespace Dialog {

/////////////////////////////////////////////////////////////////////////////
/**
 * TCYύXObp[.
 * @see CDialogResize in wtl75\include\atlframe.h
 */
class CResizeGripper
{
	enum {
		/// TCYύXObp[̃Rg[ ID
		ID_GRIPPER = AFX_IDW_STATUS_BAR,
	};

	/**
	 * TCYύXObp[EBhE.
	 * HACK: Win2k ł́AJ[\IɃTCYύXJ[\ɂȂȂ(?)
	 */
	class CResizeGripperWnd : public CScrollBar
	{
	public:
#if 0	// WM_SETCURSOR ŃJ[\ݒ肷
		afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message)
		{
			// TCYύXJ[\ݒ肷
			::SetCursor(::LoadCursor(NULL, IDC_SIZENWSE));
			return FALSE;
		}

		BEGIN_MESSAGE_MAP_INLINE(CResizeGripperWnd, CWnd)
			ON_WM_SETCURSOR()
		END_MESSAGE_MAP()
#else	// WM_NCHITTEST ŃTCY{bNXV~[g
		afx_msg LRESULT OnNcHitTest(CPoint point)
		{
			CRect rect;
			GetClientRect(rect);
			ClientToScreen(rect);
			if (rect.PtInRect(point)) {
#if 0	// Win2k ł HTGROWBOX ł̓J[\ύXȂ
				return HTGROWBOX;
#else
				return HTBOTTOMRIGHT;
#endif
			}
			else {
				return CScrollBar::OnNcHitTest(point);
			}
		}

		BEGIN_MESSAGE_MAP_INLINE(CResizeGripperWnd, CWnd)
			ON_WM_NCHITTEST()
		END_MESSAGE_MAP()
#endif
	};

public:
	/**
	 * Obp[쐬.
	 */
	CWnd* Create(CWnd* pParent)
	{
		ASSERT(pParent);
		ASSERT(!pParent->GetDlgItem(ID_GRIPPER));

		// _CAȎ傫
		CRect rc;
		pParent->GetClientRect(rc);

		// Obp[쐬
		m_pwndGripper.reset(new CResizeGripperWnd);
		ASSERT(m_pwndGripper.get());
		m_pwndGripper->Create(
			WS_CHILD | WS_VISIBLE | WS_CLIPSIBLINGS | SBS_SIZEBOX | SBS_SIZEGRIP | SBS_SIZEBOXBOTTOMRIGHTALIGN,
			rc, pParent, ID_GRIPPER);

		return m_pwndGripper.get();
	}

	/**
	 * Obp[.
	 */
	void Release()
	{
		m_pwndGripper.reset(NULL);
	}

private:
	/// TCYύXObp[
	std::auto_ptr<CResizeGripperWnd> m_pwndGripper;
};

/**
 * _~[̃TCYύXObp[.
 */
class CNoResizeGripper
{
public:
	CWnd* Create(CWnd* pParent)
	{
		return NULL;
	}
	void Release()
	{
	}
};

/////////////////////////////////////////////////////////////////////////////
/**
 * TCYσ_CAO̊{NX.
 */
template <class BaseClass_,
	/// @see CDialogSizeHelper
	BOOL bGlobalUpdate = FALSE, BOOL bMoveBaseTopLeft = FALSE,
	/// TCYύXObp[NX
	class GRIPPER = CNoResizeGripper>
class CResizableDialog : public BaseClass_
{
public:
	CResizableDialog(int nID) : BaseClass_(nID)
	{
	}
	CResizableDialog(int nID, CWnd* pWnd) : BaseClass_(nID, pWnd)
	{
	}

	virtual void OnOK()
	{
		// TODO : ɓȃR[hǉ邩A͊{NXĂяoĂB

		ClearDialogSizeHelper();
		BaseClass_::OnOK();
	}
	virtual void OnCancel()
	{
		// TODO : ɓȃR[hǉ邩A͊{NXĂяoĂB

		ClearDialogSizeHelper();
		BaseClass_::OnCancel();
	}
	virtual BOOL OnInitDialog()
	{
		BaseClass_::OnInitDialog();

		// TODO :  ɏǉĂ

		// DialogSizeHelper 
		InitializeDialogSizeHelper();

		return TRUE;  // return TRUE unless you set the focus to a control
		// O : OCX vpeB y[W͕K FALSE Ԃ܂B
	}
	afx_msg void OnSize(UINT nType, int cx, int cy)
	{
		BaseClass_::OnSize(nType, cx, cy);

		// TODO : ɃbZ[W nh R[hǉ܂B

		if (IsDialogSizeHelperValid() && !IsIconic()) {
			m_pDialogSizeHelper->OnSize();
		}
	}
	afx_msg void OnSizing(UINT fwSide, LPRECT pRect)
	{
		BaseClass_::OnSizing(fwSide, pRect);

		// TODO : ɃbZ[W nh R[hǉ܂B

		if (IsDialogSizeHelperValid() && !IsIconic()) {
			m_pDialogSizeHelper->OnSizing(fwSide, pRect);
		}
	}

	BEGIN_MESSAGE_MAP_INLINE(CResizableDialog, BaseClass_)
		ON_WM_SIZE()
		ON_WM_SIZING()
	END_MESSAGE_MAP()

protected:
	/**
	 * DialogSizeHelper Lǂ擾.
	 */
	bool IsDialogSizeHelperValid() const
	{
		return m_pDialogSizeHelper.get() != NULL;
	}
	/**
	 * DialogSizeHelper NA.
	 */
	void ClearDialogSizeHelper()
	{
		m_pDialogSizeHelper.reset(NULL);
		m_Gripper.Release();
	}
	/**
	 * DialogSizeHelper .
	 */
	void InitializeDialogSizeHelper()
	{
		// DialogSizeHelper 쐬
		m_pDialogSizeHelper.reset(
			new DialogUtility::CDialogSizeHelper(bGlobalUpdate, bMoveBaseTopLeft));
		ASSERT(IsDialogSizeHelperValid());
		// e_CAOݒ肷
		m_pDialogSizeHelper->SetParent(this);
		// DialogSizeHelper 
		OnInitializeDialogSizeHelper(*m_pDialogSizeHelper);

		// TCYύXObp[
		CWnd* pGripper = m_Gripper.Create(this);
		if (pGripper) {
			// DialogSizeHelper ɓo^
			m_pDialogSizeHelper->AddControlForPosition(
				pGripper, DialogUtility::CDialogSizeHelper::SyncTypeBottomRight,
				// GlobalUpdate łȂ΁AʂɍXV
				!bGlobalUpdate);
		}

		m_pDialogSizeHelper->Initialize();
	}

	/**
	 * DialogSizeHelper ̏.
	 */
	virtual void OnInitializeDialogSizeHelper(DialogUtility::CDialogSizeHelper& dsh) = 0;

private:
	/// DialogSizeHelper
	std::auto_ptr<DialogUtility::CDialogSizeHelper> m_pDialogSizeHelper;
	/// TCYύXObp[
	GRIPPER m_Gripper;
};

}	// namespace Dialog

#endif
