/**
 * @file  ImeControl.cpp
 * @brief IME Rg[NX.
 *
 * @author JIN
 *
 * Copyright (C) 2011- JIN All rights reserved.
 */
#include "StdAfx.h"
#include "ImeControl.h"

#pragma comment(lib, "imm32.lib")

namespace GenericUtility {

	CImeControl::CImeControl(HWND hWnd, bool on)
		: m_hWnd(hWnd), m_hImc(NULL), m_bOriginalStatus(false), m_bSetOn(on)
	{
		if (!m_hWnd) {
			return;
		}

		m_hImc = ::ImmGetContext(m_hWnd);
		if (!m_hImc) {
			return;
		}

		// ̏
		m_bOriginalStatus = ::ImmGetOpenStatus(m_hImc) == TRUE;

		// łɖ]݂̏Ԃɂ OK
		if (m_bOriginalStatus == m_bSetOn) {
			return;
		}

		// ԂύX
		VERIFY(::ImmSetOpenStatus(m_hImc, m_bSetOn));
	}

	CImeControl::~CImeControl()
	{
		if (!m_hWnd) {
			return;
		}
		if (!m_hImc) {
			return;
		}

		// ԂύXĂAɖ߂
		if (m_bOriginalStatus != m_bSetOn) {
			VERIFY(::ImmSetOpenStatus(m_hImc, m_bOriginalStatus));
		}

		::ImmReleaseContext(m_hWnd, m_hImc);
	}

}
