﻿/*
 * ZOrder.cs
 * Copyright (c) 2007-2010 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Collections.Generic;
using System.Drawing;
using System.Windows.Forms;

using Boare.Lib.AppUtil;

namespace LipSync {

    public partial class ZOrder : Form, IMultiLanguageControl {
        private List<ZorderItem> m_list;

        public ZOrder() {
            InitializeComponent();
            ApplyLanguage();
            ApplyFont( AppManager.Config.Font.GetFont() );
            m_list = new List<ZorderItem>();
            listBox1.Items.Clear();
        }

        public void ApplyFont( Font font ) {
            this.Font = font;
            foreach ( Control c in this.Controls ) {
                Boare.Lib.AppUtil.Util.applyFontRecurse( c, font );
            }
        }

        public void ApplyLanguage() {
            this.btnOK.Text = _( "OK" );
            this.btnCancel.Text = _( "Cancel" );
            this.label1.Text = _( "Select target item, and push [Up] or [Down] button" );
            this.btnUp.Text = _( "Up" );
            this.btnDown.Text = _( "Down" );
            this.Text = _( "Z order" );
        }

        public static string _( string s ) {
            return Messaging.getMessage( s );
        }

        public void itemAdd( ZorderItem item ) {
            m_list.Add( item );
        }
        
        public ZorderItem this[int index] {
            get {
                return m_list[index];
            }
        }
        
        public void Clear() {
            m_list.Clear();
        }
        
        public int Count {
            get {
                return m_list.Count;
            }
        }
        
        private void btnOK_Click( object sender, EventArgs e ) {
            this.DialogResult = DialogResult.OK;
        }

        private void ZOrder_Load( object sender, EventArgs e ) {
            listBox1.Items.Clear();
            for ( int i = 0; i < m_list.Count; i++ ) {
                listBox1.Items.Add( m_list[i].Name );
            }
        }

        private void btnUp_Click( object sender, EventArgs e ) {
            int index = listBox1.SelectedIndex;
            if ( index > 0 ) {
                string upper_item = (string)listBox1.Items[index - 1];
                string selected_item = (string)listBox1.Items[index];
                listBox1.Items[index] = upper_item;
                listBox1.Items[index - 1] = selected_item;

                ZorderItem zupper_item = m_list[index - 1];
                ZorderItem zselected_item = m_list[index];
                m_list[index] = zupper_item;
                m_list[index - 1] = zselected_item;
                listBox1.SelectedIndex = index - 1;
            }
        }

        private void btnDown_Click( object sender, EventArgs e ) {
            int index = listBox1.SelectedIndex;
            if ( index < listBox1.Items.Count - 1 ) {
                string lower_item = (string)listBox1.Items[index + 1];
                string selected_item = (string)listBox1.Items[index];
                listBox1.Items[index] = lower_item;
                listBox1.Items[index + 1] = selected_item;
                ZorderItem zlower_item = m_list[index + 1];
                ZorderItem zselected_item = m_list[index];
                m_list[index] = zlower_item;
                m_list[index + 1] = zselected_item;
                listBox1.SelectedIndex = index + 1;
            }
        }
    }

}
