﻿/*
 * PasteModeDialog.cs
 * Copyright (c) 2007-2010 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Drawing;
using System.Windows.Forms;

using Boare.Lib.AppUtil;

namespace LipSync {

    public enum PasteModeDialogResult {
        Interrupt,
        Overwrite,
        Cancel,
    }

    public partial class PasteModeDialog : Form, IMultiLanguageControl {
        PasteModeDialogResult m_result = PasteModeDialogResult.Cancel;

        public PasteModeDialog() {
            InitializeComponent();
            ApplyLanguage();
            ApplyFont( AppManager.Config.Font.GetFont() );
        }

        public void ApplyFont( Font font ) {
            this.Font = font;
            foreach ( Control c in this.Controls ) {
                Boare.Lib.AppUtil.Util.applyFontRecurse( c, font );
            }
        }

        public void ApplyLanguage() {
            this.label1.Text = gettext( "Specify paste mode" );
            this.btnCancel.Text = gettext( "Cancel" );
            this.btnInterrupt.Text = gettext( "Interrupt" );
            this.btnOverwrite.Text = gettext( "Overwrite" );
        }
        
        public static string gettext( string s ) {
            return Messaging.getMessage( s );
        }
        
        new public PasteModeDialogResult DialogResult {
            get {
                return m_result;
            }
        }

        private void btnCancel_Click( object sender, EventArgs e ) {
            this.m_result = PasteModeDialogResult.Cancel;
            this.Close();
        }

        private void btnInterrupt_Click( object sender, EventArgs e ) {
            this.m_result = PasteModeDialogResult.Interrupt;
            this.Close();
        }

        private void btnOverwrite_Click( object sender, EventArgs e ) {
            this.m_result = PasteModeDialogResult.Overwrite;
            this.Close();
        }
    }

}
