﻿/*
 * InputBox.cs
 * Copyright (c) 2007-2010 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Drawing;
using System.Windows.Forms;

namespace LipSync {

    public partial class InputBox : Form, IMultiLanguageControl {
        public InputBox( string title, string message ) {
            InitializeComponent();
            ApplyFont( AppManager.Config.Font.GetFont() );
            this.message.Text = message;
            this.Text = title;
        }

        public void ApplyFont( Font font ) {
            this.Font = font;
            foreach ( Control c in this.Controls ) {
                Boare.Lib.AppUtil.Util.applyFontRecurse( c, font );
            }
        }

        public void ApplyLanguage() {
        }

        public string rText {
            get{
                return input.Text;
            }
            set {
                input.Text = value;
            }
        }

        private void btnOK_Click( object sender, EventArgs e ) {
            this.DialogResult = DialogResult.OK;
            this.Close();
        }
    }

}