﻿/*
 * FormCurveExport.cs
 * Copyright (c) 2009-2010 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Boare.Lib.AppUtil;

namespace LipSync {
    public partial class FormCurveExport : Form {
        public enum Mode {
            EXPORT,
            IMPORT,
        }

        private Mode m_mode = Mode.EXPORT;

        public FormCurveExport() {
            InitializeComponent();
        }

        public String getPath() {
            return txtDirectory.Text;
        }

        public bool isX() {
            return chkX.Checked;
        }

        public bool isY() {
            return chkY.Checked;
        }

        public bool isAlpha() {
            return chkAlpha.Checked;
        }

        public bool isScale() {
            return chkScale.Checked;
        }

        public bool isRotation() {
            return chkRotation.Checked;
        }

        public Mode getMode() {
            return m_mode;
        }

        public void setMode( Mode value ) {
            m_mode = value;
            if ( m_mode == Mode.EXPORT ) {
                this.Text = _( "Curve Export Config" );
                lblDirectory.Text = _( "Directory" );
            } else if ( m_mode == Mode.IMPORT ) {
                this.Text = _( "Curve Import Config" );
                lblDirectory.Text = _( "File" );
                if ( !chkX.Checked && !chkY.Checked && !chkAlpha.Checked && !chkScale.Checked && !chkRotation.Checked ) {
                    chkX.Checked = true;
                }
            }
        }

        public static String _( String id ) {
            return Messaging.getMessage( id );
        }

        private void chkX_Click( object sender, EventArgs e ) {
            if ( m_mode == Mode.IMPORT ) {
                chkX.Checked = true;
                chkY.Checked = false;
                chkAlpha.Checked = false;
                chkScale.Checked = false;
                chkRotation.Checked = false;
            }
        }

        private void chkY_Click( object sender, EventArgs e ) {
            if ( m_mode == Mode.IMPORT ) {
                chkX.Checked = false;
                chkY.Checked = true;
                chkAlpha.Checked = false;
                chkScale.Checked = false;
                chkRotation.Checked = false;
            }
        }

        private void chkAlpha_Click( object sender, EventArgs e ) {
            if ( m_mode == Mode.IMPORT ) {
                chkX.Checked = false;
                chkY.Checked = false;
                chkAlpha.Checked = true;
                chkScale.Checked = false;
                chkRotation.Checked = false;
            }
        }

        private void chkScale_Click( object sender, EventArgs e ) {
            if ( m_mode == Mode.IMPORT ) {
                chkX.Checked = false;
                chkY.Checked = false;
                chkAlpha.Checked = false;
                chkScale.Checked = true;
                chkRotation.Checked = false;
            }
        }

        private void chkRotation_Click( object sender, EventArgs e ) {
            if ( m_mode == Mode.IMPORT ) {
                chkX.Checked = false;
                chkY.Checked = false;
                chkAlpha.Checked = false;
                chkScale.Checked = false;
                chkRotation.Checked = true;
            }
        }

        private void btnBrowse_Click( object sender, EventArgs e ) {
            if ( m_mode == Mode.EXPORT ) {
                if ( folderBrowser.ShowDialog() != DialogResult.OK ) {
                    return;
                }
                txtDirectory.Text = folderBrowser.SelectedPath;
            } else if ( m_mode == Mode.IMPORT ) {
                if ( openFileDialog.ShowDialog() != DialogResult.OK ) {
                    return;
                }
                txtDirectory.Text = openFileDialog.FileName;
            }
        }
    }
}
