﻿/*
 * EditMode.cs
 * Copyright (c) 2007-2010 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
namespace LipSync {

    enum EditMode {
        /// <summary>
        /// デフォルト。何も編集して無い
        /// </summary>
        None,
        /// <summary>
        /// エントリが選択されてるだけの状態
        /// </summary>
        Selected,
        /// <summary>
        /// エントリの右端をドラッグして終了時刻を編集するモード
        /// </summary>
        EditingRight,
        /// <summary>
        /// エントリの左端をドラッグして開始時刻を編集するモード
        /// </summary>
        EditingLeft,
        /// <summary>
        /// タイムライン上の左ボタンドラッグによりエントリを追加するモード
        /// </summary>
        Dragging,
        /// <summary>
        /// エントリをドラッグしてスライドさせるモード
        /// </summary>
        Sliding,
    }

}
