﻿/*
 * AppManager.cs
 * Copyright (c) 2008-2010 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;
using System.Reflection;
using System.Windows.Forms;

namespace LipSync {

    public static class AppManager {
        public static bool Playing = false;
        public static SettingsEx SaveData;
        public static EnvSettings Config;
        internal static List<Command> m_commands = new List<Command>();
        internal static int m_command_position = -1;
        private static readonly Bitmap m_author_list = null;
        /// <summary>
        /// telopの描画に必要な最大のトラック数
        /// </summary>
        public static int MaxTelopLanes = 0;
        private static bool m_edited;
        //[NonSerialized]
        public static PluginInfo[] plugins;

        /// <summary>
        /// Editedプロパティが変更された時発生します
        /// </summary>
        public static event EventHandler EditedChanged;

        #region _AUTHOR_LIST
        private const string _AUTHOR_LSIT = "iVBORw0KGgoAAAANSUhEUgAAATIAAAKQCAYAAAAc+va9AAAAAXNSR0IArs4c6QAAAARnQU1BAACxjwv8YQUAAAAgY0hSTQAAeiYA" +
             "AICEAAD6AAAAgOgAAHUwAADqYAAAOpgAABdwnLpRPAAAOCZJREFUeF7tnc/LRW1X1yUiREQQQRQHgkS8BOLAiRDJE1SDEKFZieRM" +
             "IifhIEiCl5pa2CwKtSQImhQ1iKShgqX+BeaP9z95O+vtrMf1fJ+1rh9773PO3vv63HC4zzn7+rHW59r7e6917Wtf93d9Fz8QgAAE" +
             "IAABCEAAAhCAAAQgAAEIQGATgT961LJX62ekTFb/Zx9f/s6zfWvD3v/KJiupBAEIQKBBYESkRspoFz//+OLbz5fX98+/yohAAAIQ" +
             "OJKAi8yPPRq1V+tnpIzX93a/eHzxvY/Xjz5e33y8/uzx+tPH6weOdIK2IACBtQmMCJmW8c+/9EDn7y0Ciz/2vUVg//zx+sbz5ULo" +
             "n//3s/4PPyvab09B7avYtqeo9vsnpS/r28v++trDifcQWJPAjJA5IRcpE6r43ubE/MfSR08lLQr714+XC9b3P96bqP3nZxkXQU9H" +
             "XYyqfkzM/Mf6dDu8PPNwa57LeL0wgRkh84jKBcOEyL77j08x+YPH7+8LLE1QTMTiXFmMmFy4/ueznf/6LPsLz8+Wglpd7+fvPT9b" +
             "m5aqfvfjZaJmZb54vH762Z/Z8UMLjymuQ2A5AluFzOr91ONlaeJffwrIt56fbU7Mf37w8ebXHi875oL2m8+Dnkr+ybPeHz9+W7sm" +
             "htaufW+fTSw9HTUR835MzNx+69PKxPSVebjlTmccXpXAEUL2E09BcUEygYk/JigmMCZoJmYmRh4xeUT1T57H7POPiLC5kFkds9cE" +
             "z0XL7bc+7bvvebwsUrM6aseqY4zfELg9ga1CFlO+f/UUod8NEVG8IeAQbT4rRlQmTD6XZumgtWmfYwrrEZnfUVV7XQh/8VHP2vfj" +
             "tx84HIQABP6cgM93mcDYy4XAfvuPikechI9zYH83iJDNj8W5sVjnHz6jJxOnL0I5K/93nsdi2hiXfagtPtnv9lsb3LnkDIfAYgRc" +
             "GGaFzOp98/H61uNlKaVN3Nt8mKV3ntKZmFmkZW1bOmjRkwmPpX8qTiZA1paniNZWFi1m31nfdmPA6v/W4+WpZW9d3GJDjbsQuD8B" +
             "n4dygYm/3fss5YtrxPx9nOy3+bFqHZnf4fT08A9DWRM77TeOgi7OzSb7uXN5//MWDyHwFQKZgKlYVHNXvi7MjsflF96BiZlFWl7f" +
             "3kexcyH75aeQaSSVPVGQfWd9+/eIGCc4BCAwRGDmkaWRBj2t5G7jCC3KQAAChxB4lZBlUd0hBtMIBCAAAQhAAAIQgAAEIAABCEAA" +
             "AhCAAAQgAAEIQAACEIAABCAAAQhAAAIQgAAEIAABCEAAAhCAAAQgAAEIQAACEIAABCAAAQhAAAIQgAAEIAABCEAAAhCAAAQgAAEI" +
             "QAACEIAABCAAAQhAAAIQgAAEIAABCEAAAhCAAAQgAAEIQAACEIAABCAAAQhAAAIQgAAEIAABCEAAAhCAAAQgAAEIQAACEIAABDYT" +
             "+Pbmml+teFQ7mTmvbHvW/ZYtZ7Jz1i/KQwACDwKvvIhf2fbs4CFks8QoD4E3EvjGjr7ixb2nncoEb/8Vbc+43fLz1Qxm7KQsBJYi" +
             "oNGFffZXD0Qspxdx1k4WycTvqr5H2jZbvVxmf+uY1638bvkZGWkf6pvyjOV7rDkOAQg0CLQuttEUKl7oFjFl4hiFxs0Z7XumXFVW" +
             "RWqmzWhvKzL0PmLUWIlViy0nLAQgMEkgXpgqSHZBZqmcXoRRvKpjsYy3GS/y2I+XzcpF96pysZ62ocdG7PU+Mx+yiMz7iPapAGqU" +
             "ae18Om2ePHUoDoHzEMgiDE3x9ALLLkL7zi/cWD+L1jRqy8qrwGpE1xI5F+AsGsqOVfa2/GwJfPwDoDao74jXea4FLLkogSq90ou9" +
             "mttRMYlik12gWYQyWqcqV4lVLF8JUq/vkSgqS5NbqSVCdtGLBbPPS6A1T+QXeZZeVumoCkMUriiOHr15OhXb0zqZjZWAxna1XuuY" +
             "21H1HSPNmGZqWtkSvpbgnvcMwTIIXIBAduFpWlnN3cSUsdVOL5qLohTbrCKdzD6NvqKI9Y5pOpzZm6WHlV+VfZUYqq0XOG0wEQLn" +
             "JBBToSolzCzXeq12tN0s0svKZBGQltPUMUvtYtQ10mblS2Z3ZNPySyPRc54NWAWBixKoRKZ30ao4tNpRNNUkt/fZErXYbzXnFFNZ" +
             "Fa7Kr6rvnp8qZGqfRpcjIn7RUwmzIQCBrQQ0tY3ttI5t7W+2nqbMlYjPtkt5CEDghgRaAnEm8TiTLTc8DXAJAtcmcHYhG0nVrz0C" +
             "WA8BCEAAAhCAAAQgAAEIQAACEIAABCAwSqC1CHTrsdG+W+VYnHoERdqAwCIEPilWiyDGTQhA4NUE9q77evXyhVe3/2q+tA8BCLyB" +
             "wOjD1dUzk2ZifP4xi/D2PJP5BgR0AQEIXJ1AFLJMrHo7VbiQ6Q4XzqUngKP1rs4Z+yEAgRcSyLa0se7ic5Oe3mWi1isXTfeysT3v" +
             "ywWxOvZCBDQNAQhcnUBrq6AYralgZZGcPhweRUn70fZa7V+dMfZDAAIvJqCCFCfXq/mznuj00tVWxFcdezEGmocABK5M4J1C5lFZ" +
             "K3JDyK58NmE7BD5EIIu6WilhJjStyM3nvnQurppbQ8g+dCLQLQTuQCCmlCMbKbrPo/W03JZ6d+CMDxCAwAsJtMQr7tbaKxdNzMr6" +
             "dwjZCweTpiEAAQhAAAIQgAAEIAABCEAAAhCAAAQgAAEIQAACEIAABCDwcQKf2GPsFRshvqLNjw8OBkAAAmMEXi1k1VY9Y9aNlzpK" +
             "yI5qZ9xySkIAArsIxIs225RQV+Fv6awlZEdthNjzY8ZuhGyGFmUhsJNAthOFNRkf76lEJNuOR0VltJ1eRBefmZyxT9tt2aNC1vJ7" +
             "1l632f2Iw4bo7TyJqb42geoijxedE4pl9X0r4ooXbnzWMYpR1oeOjPaxtV0VkswvtbOyrydmVk/3Ohvxde2zEu8hsIPA6AaEevFm" +
             "D2Jn0Ua8oDOh0P4zIYuPLWXClqWYo35plBf71wfaXaDcngy72ac7bni5ytejUuQdpwFVIXA9AjGtrCIcvRizeaR40bYiqShgWd9V" +
             "ZFf1GQUl1t3il9vmvoxEmaP29uy/3pmDxRA4CYFeWhmjhyxayVKman7MBadK4xTJTDsz6WpLUPSYC1qWClaRVlU2E7yWUJ7kFMEM" +
             "CJyfQHXhqjBUQhEjGBW93gUdhTGKQkwde+mppmmtPjPhaQmg2hTtVbuy9DJLe13MtS3SyfNfK1h4cgKagmnkVEVdMQ3tpWDZBaxz" +
             "Tq1Jc7/wY4Q0IhTRtxG/qqgpCk3GK/oXxTSL6CK3THhPfrpgHgTOS0Ajgvh59Fhr0ju70Ef76KWco/apDTP1enUz/6oItdXvec8Q" +
             "LIPARQjElG5GZKKAtVKk3gVcpZSZkG2xT4V2j5C5cI3YnAl8VY8U8yIXC2ZCAAIQgAAEIAABCEAAAhCAAAQgAAEIQAACEIAABCAA" +
             "AQhAAAIQgAAEIAABCEAAAhCAAAQgAAEIQAACEIAABCAAAQhAAAIQgAAEIAABCEAAAhCAAAQgAAEIQAACEIAABCAAAQhAAAIQgAAE" +
             "IAABCEAAAhCAAAQgAAEIQAACEIAABCAAAQhAAAIQgAAEIAABCEAAAhCAAAROQKD337lfYWL2n7Jf1c9R7bY4bWX47npHsaAdCHyU" +
             "QHbhbL2Ytjryzv6O7Ash+/8jfiTTrecQ9RYn0BKyd/2H6mhD9h+0jxoi7WdPu622tvaztV4Uk3eNWWSHkO05k6j7NQKenumJVX2O" +
             "5f0C8LJVqtfroxelaLuZDdnQjvQb+87sV98qEe/5rlGIsYt1VJAq272daJf7ngnSLANva6Rer2y0NeNs30WbZ/rkUobAlwRa4jVy" +
             "LAqZl/cLNJ7k1V/i6uIfrWvlqmiiZ39LwLJjesHN2KjikzGq+KkAVnZXIjbCfs+Y9Ti3+o/j12un9ceOSxoCXxLwk1mjrOyz/yX1" +
             "lC5ehH7h6cXhJ238K6z1KrGo6nr/ehHrST/im/ZdcYhttfqpjqkwRd9ax1o8M0HP+o8peDVmekn02EVuPTbav54/MbIcPU+4hCHw" +
             "ZWqjIX28aLL0MZ5w8eLTE1PTJS0bL6aWGFViWkVk0Z+eb+qrfs5s9O9a/VS+qyBF3/xY1q6KnNYb4adC4fwyn9UGFdw41lnZzP8s" +
             "iu35nI0Ply4EviTQC+Wzkz67mPSE1dRHxSaKgApiloZkUVrrIlGx1CFv2asiU/WjPqiIZDa0uPSYqQCosLcispZtKk5ZRJjZltXT" +
             "uhrxZWObiWNvvLiEIfAVAtkFnYX6/td29GKavWBbUVU81rqgqpM/+pP5lkVH2k+WgmUsYlpVRThZvRbfmTariCwTvZE/PlFkZthp" +
             "2Vb/WaRd+VydJ1zWEPhaaqnCkUUefuFlJ2EViejF2oua4gX/6rqVUEUxiqlTPG00LcoEtYreol+ZDZnfzm0kIoxlq+i7NYbqs4pz" +
             "Nkajfug5NGMrly0EUgL6lzx+1vfVseyv5WjZLPVRsag+H1m3x6F3fMRGj1a87Fa+rXo6yEfYrePbanOm7J52uJwh8DUCfoHpheYn" +
             "pZ9wWy+82E7v5M2GJ9rXErk9dUcu+MqOln8thqPHMsGOYzUi6NXY9v5oZD637GmdQxnj6rst5wmXNgQgAAEIQAACEIAABCAAAQhA" +
             "AAIQgAAEIAABCEDgKwR0yUKFZ7QceCEAAQi8ncCoQI2WcweqBbdvd5AOIQCBNQiY6PgygGwFflw0qgtcK4HTxaxGclYM16CPlxCA" +
             "wCEEqhX9sXFdza7HslX1USCtvIklYnbIkNEIBCDg0ZFGV62FwC5K2aLibHGoPp4TI77ewlZGCAIQgMBmAlGstJEqIosRVhS0WD4K" +
             "Vyuy22w4FSEAgbUJ6KM5WeqnYpWlnC3hQ8jWPsfwHgIvJ5BN5Fe7SPg818jcWS+CI718+dDSAQTWINCaeNflE3GyXsXvCIFbgzhe" +
             "QgAChxJQEdNJfP+cCZpGZHp3Mh7XyIs5skOHkcYgsDaB1rxXNQeWTey7iFXRHUK29nmG9xB4OYFWJKWdxzVg1eR9b95rVDxf7jgd" +
             "QAAC9yKQTfZnHurK/7gGLc6RZRGYls3m1O5FFW8gAIG3E+hFUll0NvJd5chsf28HQocQgMA1CWST/S1PshX+o+WvSQirIQABCEAA" +
             "AhCAAAQgAAEIQAACEIAABCAAAQhAAAIQgAAEIAABCEAAAhCAAAQgAAEIQAACEIAABCAAAQhAAAIQgAAEIAABCEAAAhCAAAQgAAEI" +
             "QAACEIAABCAAAQhAAAIQgAAEIAABCEAAAhCAAAQgAAEIQAACEIAABCAAAQhAAAIQgAAEIAABCEAAAhCAAAQgAAEI7CIQ/1t4fL+r" +
             "USpDAAIQOIrArDDNlnc7t9Y7yk/agQAEbkxgRmBi2dn/HD7Tz41x4xoEIGAETBD8pUSqYy4iWi+Wd2GKZb0/jap6/bTKRwHstaMp" +
             "beU3ZwYEIHAhAhrVtOauMhHI0jwvF4WsateFRMWoSh+zdlQwK5tGfbvQ8GEqBCCgImaC4K/smH2nohE/63ttK6uromdlev3YyMVy" +
             "/j6O6Eg7sW+3lbMCAhC4GIHW/FR2LF74KgKaPrrYxFQyEzZtR8tn0Z2mpypkPcFspaKz83QXG3LMhcD9CKhIRA+zYyNipQLY+lwJ" +
             "adVPlRpGIctS1J5NWUR3v9HGIwjclEAV7WhUpBHQiDhl81YqGD4/lkVvWZ8j82NZvy1743wa6eVNT3Tcuj8BFxOdE3MhiWITL/qW" +
             "+MzMcbX6ceHTCC1+P3PHsirbSrHvfwbgIQRuQkDnheLnVxyLIujvR/vRqKlVL+snDlk2H8Yc2U1OatxYk4ALRHVxZ2lXT3xmBXHE" +
             "hlERHLE3iihp5ZrnPV5DAAIQgAAEIAABCEAAAhCAAAQgAAEIQAACEIAABCAAAQhAAAIQgAAEIAABCEAAAhCAAAQgAAEIQAACELg3" +
             "gew5Tn2mU5+j1Gc7s2c9700N7yAAgdMQ6AmWGxqFTHe3qLbtOY2TGAIBCNybQLZ1TtxiJ9vSx4homSh4PNB973MG7yBwOgIxrdR9" +
             "x3ybn2p/Md0osdo48XROYxAEIHAvArppo3sXRSmWqTZ51I0SicrudZ7gDQROTSAKk4tX3Conbr6YRVw9YTu18xgHAQjch0Bv91mP" +
             "rhCy+4w5nkDglgRmdnCNk/0xFY1gSC1veZrgFATOT6C382tLqHpCeH7vsRACEIAABCAAAQhAAAIQgAAEIAABCEDgjgSy/4Fpfo48" +
             "F1nVdU6t4/o4U7bottf+HccDnyAAgUkC+pB3JkAjYlR1O1sX4ZocQIpDYHUCow+C63OUMVrTtWVVVFX1ZW15+1nd1h3S1ccP/yEA" +
             "gZA6xhRSBScul8iiperRJY3sdNlF9hB6HJRMPBk0CEAAAiWBTLw0OvLKmSDFqCmu7tdHmbycCmcrihuZp2NoIQABCHxnUl9TuNaK" +
             "+/jgtwtNVb6K2Kq5uSqNZZggAAEIpASySEgLZtFWTBtVkKq5sFYk50IaBTX7jseZOJEhAIFuaplFWjqZr3NfWTQXxWw0Issm/Nny" +
             "h5MWAhDoEojRVLU1jwpXS8jsWGzHPveELLuZEL+Lc25dhygAAQisR2AkLYwT9P4+kmrdtYzzXdVdy14UmInaeiOFxxCAQDelVDHK" +
             "UrqZyMo7HBUyFVTtnyGEAAQg0CWg82AqJHEJRC+y0s5mBTDaondSu45QAAIQWI9AJWA6D9ZK71qp5agAtoSUdWTrnZd4DIFdBKoI" +
             "KE64V0sgeksjZusRje0aSipDYD0CPdHoiZQRa5XJbhLEebT4Pivbs2+9EcNjCEAAAhCAAAQgAAEIQAACEIAABCAAAQhAAAIQWJJA" +
             "a6ucDEhVfqasPkBudWfaXXKgcBoCEJgjkAlNq4WZ8keURfTmxpPSEFiGQPbsZG95hD5Q3loTlpXNyld2xIGoxHBGJJcZWByFwGoE" +
             "VAh668Rmyh9ZNj41ENeS2fc9m1cbU/yFwFIEZoQmm9NqCchM25o2Zu3OPqe51EDiLARWI9Ca6G89y5gJk363pe2Rdl1E7ffsg+qr" +
             "jS/+QmBJAiMPYmdiE+e1KnC9tmfa7U32k14uefri9OoEqol4fZaxlyJmc1Qjbc+2W6WWPo4I2epnNP4vSaCKhlowRueuZtseabea" +
             "7G/dZV1yYHEaAisRiGIzEs1UZbJIaabt0XZ7EdlKY4evEIDAk8BeYdD5ryhIe9qu2t3TJoMOAQjcmEA2gd6buK8m8LO7idp+1nav" +
             "jLY7Ej3eeMhwDQIQyAjsFYbekwBbqVft7rV3qz3UgwAETk4g3qnsTZ5r2Z5ro23Pttvrl+MQgAAEIAABCEAAAhCAAAQgAAEIQAAC" +
             "ENhCQBeyWhv+XfZc5ZY+qAMBCEBgE4FMoLKGELJNeKkEAQi8gsDW6EkXnWYr9H35Qywb14LN+LNHYLWf3nq0GbsoCwEInIBATAdn" +
             "LvBMkDJxi4tiZ0Vz1J7RcjH9jehHRfIEw4UJEIBAlSLahVxFT3rBq4D57hUuEtVD3bEPKzuytU8mNr1Frq3Hk1Sw4no0xIzrAwIX" +
             "JpBFUb0LXNNIFcLsEaS4eFafteyJk4vlyAJct6W1S4YLqQplz44LDzOmQ+DeBKKQxegqRmgtYdI6GnnFdC4TolYE9aqIrCVyiNm9" +
             "z3e8uyGBOD8WBSlGLCOT+jqZr/VH0r2egBwheEfYccPTAJcgcG0CCNmfj9+oUF57xLEeAjckoJGUR0U6h9WK0DR1dEzZTYCYrmY3" +
             "DVqIR4Vma9Q12v4NTwNcgsC1CaiQZRdzljbqZHlWrxIyvTvogvaO1NJFN5vziwJ87VHFeggsRiCmltlFnt2ddETxWC+aaYlh6y7j" +
             "0ZP90XaNCBGyxU5+3L0XAb3L6JGURk4xitEUsScC2Q0DF5JYtxeVaSTYGoleW9nxXp17jTzeQOBmBHRuTC/o1udM4Co8rbKjInJk" +
             "OV8Oki0LudkQ4w4E1iBQRSgjwjEqBJkgjtZdYxTwEgIQgAAEIAABCEAAAhCAAAQaBPTmQQtWVja7SwpwCEAAAm8lMCpkVTmE7K3D" +
             "RWcQgEBGoLfWzOqoWMVlHt5m/G7kRgSjAQEIQOAwAiNCFsVMF+v6sezxqcOMpCEIQAACI/NeI1GUPlHg7WZp50h7jAwEIACBQwjE" +
             "R4Kqx4NiROZPGGTpZeupg0OMpREIQAACe+bIVPBc3OL38YF0aEMAAhB4G4E4R6aPBmW7UVSPM808EvU25+gIAhBYg8DoZH+c1I+C" +
             "5w+3624ZzJGtcf7gJQROQWBEyPROZbZ2LLubeQoHMQICELg/gS1CFufCtD7zZPc/Z/AQAqcjsEfIomjFu5m6l9rpnMYgCEDgmgSq" +
             "ZRat79XTajFstWyDebJrnitYDYHLEhgRHS+T3aHsfXdZMBgOAQicj0C2xKL3nXpRCVps53yeYxEEIAABCEAAAhCAAAQgAAEIQAAC" +
             "EIAABCAAAQhAAAIQgAAEIPA+AiPbUrs12a4W0dLRrazjGrPRrYHeR4SeIACByxFwIVHDVeAywWuVGRHIqszlIGIwBCDwWQLVA9zx" +
             "caRsE0RfB5ZFYfo4UozosgiutTbts3ToHQIQuASBKGTZXvr6YHdr37FM/LLdYQ1MJXaXgIaREIDAuQio+Kjw9ASnEq9eRGcUZp7d" +
             "PBc1rIEABE5F4NVCpnNwVdR3KigYAwEIXIuAbs3j2+q00sRqnkvrxC164nudM2OO7FrnDNZC4HQEXilkPhemc2KZkJ0ODAZBAALX" +
             "IaBCFueuohC1IioVKp1Xy9JJ7yf2cR1qWAoBCJyKQCZklci0FsRmO8BWIsWC2FOdAhgDgfsQyDZL9Lmr6GVVripTbcKYba54H5p4" +
             "AgEIfITAiOC4YTo5rwaPilTcdLGa8P8IDDqFAAQgAAEIQAACEIAABCAAAQhAAAIQWIZAb4eK2d0pZss76K31lhkoHIUABNoEWtvz" +
             "zArMbPmekG1tjzGHAAQWJKAPiuvWProDRoWoWpOWle89MI6ILXgi4jIE9hKIYqZCpqLSEqHqWMu+7DGpWL5aGrLXZ+pDAAI3JpBF" +
             "ZO5u9bjRVuHxaC9u1BgX4iJiNz7RcA0CewnEyCm25d+7wPhnK1NtqtjavUKPHR3N7eVAfQhA4AYE9LlHc2l0jmxmTmwmtcxE8wao" +
             "cQECEHgVAd/VorczbPbc5R4hi6lkFaX1HoV6FRPahQAELkYgm2jviZq7uEfIYso6M/92MbyYCwEIvINAFKN4d1LnyFrrzWYm5KOA" +
             "9ebLsijwHUzoAwIQuBiBKqqqdrDI7lrOCFnEo2mtHmOu7GInE+ZC4BME4qR+a+udaq5qT2oZF9lmdz1bIvcJVvQJAQickMCWRa6Z" +
             "G730sLVCv1eXiOyEJw4mQeCsBOIGh1ts3JpaZpP82v/etrf4Qx0IQOBiBFQoRha3Zi5uredRV6v+xZBiLgQgAAEIQAACEIAABCAA" +
             "AQhAAAIQgAAEIAABCEAAAhCAAAQgAAEIQAACEIAABCAAAQhAAAIQgAAEIAABCEAAAhCAAAQgAAEIQAACEIAABCAAAQhAAAIQgAAE" +
             "IAABCEAAAhCAAAQgAAEIQAACEIAABCAAAQhAAAIQgAAEIAABCEAAAhCAAAQgAAEIQAACEIAABCAAAQhAAAIQgMCDQOs/jQMIAhCA" +
             "wBSBTwnKSL8jZaacpTAEIHBPAp8SC+9X/6N5pPwp2+450ngFgZsSMKHwlwuKi0cUkVguExo/rph69ay89ZuVy2yz8r02Eb+bnqy4" +
             "BYEWAY2MVJRUGDKB8/b1WBVdzZZTka36Q8Q41yGwKAG7+E0o/KXCFlM/j55UWOLn+D625e17VOXRWMSeta92efmeLa2UddGhxm0I" +
             "3JNAjGAycdK0L0ZrfswFST/HqKlVL6aKsZza1rNVRfOeI4ZXEIDA1wj0xKKXVsboKEZa2m4Uuapc/F7ft0QyK8tQQwACCxHI5sc0" +
             "dctSORWmSqgiSk9hq/mxmCpmwtWyNYvWFhpGXIXA2gQ8lavmvDza0TuFLaHxVFNTxphqqjhW7bv4VWmqtsm82NrnM94vTkAFYOZz" +
             "q2wmLP6d3kSIQzB6zEVTU9zFhxP3IbAmgXhHUcUhioSXmxWa0XpVuUws1ebK7jVHFK8hAAEIQAACEIAABCAAAQhAAAIQgAAEIAAB" +
             "CEAAAhCAAAQgcDYC2WNA+nB4y+ajHsY+qp2z8cUeCEDgDQT2CIjX3dOGu3hEG2/ARRcQgMAZCWS7UMQ1W60V8VHI9q6c18eMzsgK" +
             "myAAgZMS2CMgGpHp40xZtKWPHGmZ2EaW4sY+syiuat/6aR076fBgFgQgMEJg6xyZPowdn31UgalS0OwhcX3I3AUoCl5WT8tl9SIP" +
             "UtmRs4MyELgIga0RWUvIXESynTAcS9zRIopO9shRJpIxcssiQX2kqWfvRYYLMyEAgYxAb44sS8daUZwKTCYg2ma1Y0avnNarRNnL" +
             "qd3GY+/cHmcVBCBwAgJbIjIVp5j2aXQU269SzkqQsvkztTdrPxOnlsidYBgwAQIQ2ENgVMg8VVMR0zucmgbGrXl0bsvLtoTMoyjt" +
             "XwWziuoyMYxpLRHZnrOHuhA4CYFWmthKRau0rCVkPhemk/+t1FLnz1oRWWw/m8zP0uSTDANmQAACRxCYjUx65ePxbALfbfZIK36u" +
             "3s+0GZmM1juCI21AAAIfJKApot71U9P2CJlHczHtzMRrtpyKl4qkimfPhw8OB11DAAIQgAAEIAABCEAAAhCAAAQgAAEIQAACEIAA" +
             "BCAAAQhAAAIQgAAEIAABCEAAAhCAAAQgAAEIQAACEIAABCAAAQhAAAIQgAAEIAABCEAAAhCAAAQgAAEIQAACEIAABCAAAQhAAAIQ" +
             "gAAEIAABCEAAAhCAAAQgAAEIQAACEIAABCAAAQhAAAIQgAAEIAABCEAAAhCAAAQgcAIC2X+sPoFZm0y4ky8O4I4+bRpcKkGgReBO" +
             "F8rVfbm6/VuutBV93sKJOg0C8SS6+n+lvoMvrYv66uNTnYYIGRK1m4CfRPbbX7FRPcmyz7ENrZu1mRnd679qJ37fE7JeH1UqV/Vh" +
             "5UeOZRdqZkv8zkWr4l2NS49TTzSysexxm+0zO+fsuyjUI33G8Ro9z3ZfMDRwTgJ+AuhJ1Lqos2N6IvUEcFQsW+3GPmK5LHJp2TN6" +
             "rGeL2lP5ONJfJmS9elX/s2Mx48eWPiuOLfFW0Ro5P895xWHVSwj4iegnkf2Ofx31ePYX2wzzevF9rGvHR1Kjkf5jXw5F+1dYKnTR" +
             "ni0+qjjE/qtj8UKt2Dh7t6/HWy/++Hmkv4xTHMM4ZnvHpmdra1xbdbecZy+5mGj0cwT0JPB0KROneCxerHrxtFKEKlpyoVHBUfuy" +
             "C7vVfyVosd0RIdM+Wv6rL+pTlRJVbUbuPi6tcapEPdoV28kiR28j8yWzpxLyTIAy9voHcPR8qFiO/NH83FVHz4cSyC6cllhlaUQv" +
             "BdLIoooA4gmZvdd+KvHJLlD1s3XRzfrY8r8S7RhFbrVl5I9KT3BaYzES4UY/Mnv0D1pmj46NjmsmsvpH1j9nEd2hFwyNnZNAFilk" +
             "F7KfgLMXuZ6EMZ2rxCqmVtVJnkUjlSjrxRP71RM/8tA+tJ2WkGZRZEvQ3efRNitbsgs8clHfVWhbohLTyhitjQh5dU5lYjnKrhKt" +
             "eP6c86rDqsMJ+EmjKUf8Sxsv7uxCq9KVLDXIoqUokiqsvairZVsWbWR+xouyEq8ZH+OFrcIYhSSzxb/rzQepOI1yUnsqIWtNDegf" +
             "oMxHTUuzqEo5zfRZlW39MTv84qHB8xHIIqV4suj77JheTJVoZelWVrbqX8u2bFPSWd/+3V4fR/xv+RT9Uju3sGhxin+osrOx1b9G" +
             "g3ruHGHrnvOh59v5rj4sOoxAvJgzUfMTK0sj/MT2etlFUB3LhCYr27uwos2VUMYTvGerXqzqYxYR9dqsRLTytycIvT8+lRiMjEXP" +
             "1izy6Z03M2OYjVU8V3r29c6Bwy4cGro+gZnU8aretnxcwf9q3LLo86pjjN0Q+Nq6sDv+Jdya5q1wetxxvFcYN3xMCMRU5a4ndsvH" +
             "FfyvTvy7jjcXOgQgAAEIQAAC7yJQLWHQ7/fYc2Rbe+ygLgQgcFMCW4RsVphmy4+gfkWbI/1SBgIQOBEBvduoC1Nbd+RmReQVd/dm" +
             "bTgRekyBAASOJlCJTFxTF/scXTXeEspMhPy7EYEateFoVrQHAQiclICJgt5xbC2snRWR0fKxXE/MRts8KXLMggAEjiSg4lEtbs0i" +
             "stElBy2h1Da8bM+OV6SqR3KlLQhA4I0EZiObmP71oiZ3Q+u06rmAWV0XNX9ftfdGXHQFAQickUAW2WRpZhSRWEdFqZr7iqKkwuSf" +
             "o4iZDTGSU1GbteGM7LEJAhA4iMBsiqblRwTKTY03D1yoMjeigNnxWFbfa+SWieRBqGgGAhA4IwFNK3upopavRMXFR0VFd4VQEYyi" +
             "5W3HKK1qLxPXaMMZ2WMTBCBwEAGd6O81m82njYpIdmOgigZbUeIeG3r+cRwCELgggWqeqbobmQnMaBvZ3UlNOSPCGK3FObs9Nlxw" +
             "iDAZAhAYJeAi42lc/K3ikqVsmv5VaV3VbhWtzUZxmhqPLg8Z5UQ5CEDgxATiBT9y8WdlZttoRWMRVWXPkTaceGgwDQIQ2Eqgtfyi" +
             "irb8+1Eh1In/ytYZIZuxYSsb6kEAAhCAAAQgAAEIQAACEIAABCAAAQhAAAIQgAAEliGQLeVofbcMGByFAASuQ6D3uNN1PMFSCEBg" +
             "WQJxBb6uzK82cRxZurEsUByHAATeT6B6dEkjNSK3948NPUIAAoMEekIWH4sabJJiEIAABN5LwIWs2ipI9yMjrXzv+NAbBCAwQCDb" +
             "pSLbv8ybQsgGoFIEAhB4LwEVsihiuqEiIvbesaE3CEBgkEBr3zAVssEmKQYBCEDgvQSqnWPNCo/OiMTeOyb0BgEITBCoJvh1Poyl" +
             "FxNQKQoBCLyXQLxj2du1Ndtd9r3W0hsEIACBBgFNHWc3SQQuBCAAgY8TcOEa2Q12pMzHHcIACEAAAhCAAAQgAAEIQAACEIAABCAA" +
             "AQhAAAIQgAAEIAABCEAAAhCAAAQgAAEIQAACCxOI/zhEMVTHWiv8db+y3s6xrf4XHhZchwAERgm0RKZ3LB7X99Uxs2v02KgPlIMA" +
             "BBYnoA+BV6vwdVeLbAcM3eI6rv737X1aD52zc8biJyPuQ2APgSy1i6Kkx3U3WP0cRS62k22BXW0JxDZAe0aUuhBYlED2D0Oq1DLb" +
             "1joKUm/jRUNcRW9Z3UWHBLchAIFRAlmqV4map4dbhMznxmK6GefLKmEb9YNyEIDA4gRGUksVnVZKWEVVLoQxIvN2de8yUsvFT0rc" +
             "h8AWAq39xeIxvRkwWi+LvqKdo/ubbfGNOhCAwEIEXKSyaCgKmApbJUjaTm/+q9X/QsOAqxCAwBkJkDaecVSwCQIQ2EWA+a9d+KgM" +
             "AQh8kgBbXn+SPn1DAAIQgAAEIHBOArrgddTKaqFs1V72vX/Xep5z1B7KQQACNyHQehC7cvGMQma2xnVtmdDpzYObDCFuQAACM5GN" +
             "CkUUhlGRyMSmtRDWRih7YkBX+vtIjtwQyBbyciZAAAIXJxBXzreiGnezta4rEzRts1rEmq0f0/a079batewmAWvOLn6yYj4EWqmi" +
             "RldZFBSFLAqCLnptRUVRiFRU/FlMjZjiM5pRdNWfXmqp5RE1rgkI3IBAJhg+1xQv8ir9rFbgezqYRV6VWGWiFNNFjRpj21Vau2X+" +
             "7wbDigsQWJeAC0X2SJGKSDUfld0EqObVenNZak+M5FpRWRTRzG7mx9Y9x/H85gQ8SqrmrlREekLWE6ks6tMIS/vIbKgiPp3L87oq" +
             "gJnw3nyocQ8C9yYQL/boabzY41xVliKO3ASIEVEleNqnC59HW61+Mttj6hnvdkZ/7j26eAeBRQhoxJPNO/XmnLxOa+5MhSYTs0yo" +
             "su96kZ+KcxSxGLX12lnkFMBNCNyDQEy9srStEjKfV/P6mrJphKV3PFsRoKaJ0a6Ru6MexcW5s6w/xOwe5zBeQOA7K+NVKOLkf5y3" +
             "6kVN2ZxXJRbV/FgmnCOCo0JaRWJZCstpAAEIXJzA6NyTC0Oc78pEIVsiEeu0cGkfUUSrelk6XNmgbYwI5MWHF/MhsBaBmYs6KzsS" +
             "efWIVinkXtsyAZtps2c3xyEAgZMQmL2wW3NelXDEOiNuZyluVa9XdrbvEfsoAwEIQAACEIAABCAAAQhAAAIQgAAEIAABCEAAAhBY" +
             "gkDr2Uaee1ziFMBJCFyfQOsRJ4Ts+uOLBxBYgoA+zxmdHl2MuwQonIQABD5PoFq9Hx/i1gfM9Vgmcv4d0dvnxxgLIHBrAq0HxrOI" +
             "TB9Fip8r4ULIbn0K4RwEPk9An7mMD6KrkMUV9ppa6gPs2c4as08gfJ4OFkAAApcgoA+SV1FYJlzmoItbJWzsWHGJ0wAjIXBtAtWk" +
             "vQlUL7V0IbPfldBxU+Da5wfWQ+ASBKLQuHhlUVYrIsuEzL/L9ha7BBiMhAAErkWgd9fSBa6aP0PIrjXeWAuB2xLQifjR/cVa9Ugr" +
             "b3u64BgEzkug2vdLRa0SuThnVkVp5/UeyyAAAQgEAp6q+lcsu+D0gAAELk8AIbv8EOIABNYl0NvCel0yeA4BCEAAAhCAAAQgAAEI" +
             "QAACEIAABCBwdgJ617Gyd7Tc2f3FPghA4GYERrfcGS13Mzy4AwEIXIGA7lZRLZ0YLXcFn7ERAhC4EYH4zGXc/cJddPEaLXcjNLgC" +
             "AQhciUC2dY8KmX0eLXcl37EVAhC4CQHf4SJu5aPRmW73Ez+zkeJNTgTcgMCVCYzu9Dpa7sossB0CELgogdGdXkfLXRQDZkMAAlcm" +
             "kO0hFjdU1P+aFO9qZuWuzALbIQCBixJAyC46cJgNAQh8nYBGWlYiW1M2Wg7GEIAABN5OYFSgRsu93QE6hAAEIGAERnd6HS0HVQhA" +
             "AAIfJzC60+touY87hAEQgMA6BEZ3eh0ttw45PIUABCAAAQhAAAIQgAAEIAABCEAAAhA4O4FXbY74qnbPzhP7IACBDxB4leC8qt0P" +
             "IKJLCEDg7ASyx5GOsPlV7R5hG21AAAI3I1DtYJG5GXeH9eNxp9hYR3eSvRk23IEABM5EoLXLq9qpq/c1fYyfvazulHEm37EFAhC4" +
             "CYEsyjLXspX5regt7hBr9atNF2+CDTcgAIEzEchSQxelKgKLW2BH0cuiu6rsmRhgCwQgcHECKj6tZySriCzbaLFX9uLYMB8CEDgT" +
             "gZ6QeUQV//lItUNsFZFlqeaZGGALBCBwcQIzc1nVzrHZFj5EZBc/MTAfAlckEFPK3hY8erz1uVf2iqywGQIQOCmBGcGptrvOtvCZ" +
             "afekaDALAhCAAAQgAAEIQAACEIAABCAAAQhAYEECoztXjJZbECEuQwACnyYwI1DxyYCZep/2kf4hAIEFCJgoxYWvLZHqLddYABcu" +
             "QgACZyRQbc9T2RqfAEDYzjii2ASBRQioeMWozBDEdWKaUs4K3yJIcRMCEDgDARezkSiLObIzjBg2QAAC3yEQ00T73Jsfi3uRaV2Q" +
             "QgACEPgIgSptrIxRoRuJ3j7iGJ1CAAJrEGhFX9kxnRtDxNY4T/ASAqclkEVWejdShSrWYY7stEOLYRBYh0AUolZkpRsr+rya3uVc" +
             "hxyeQgACpyIwI0YqfNnGi6dyDmMgAIF1CGST/ep9Fb2xnmyd8wRPIXB6AjOT9myeePrhxEAIrEugN9Hvc2MZIdaTrXve4DkEIAAB" +
             "CEAAAhCAAAQgAAEIQAACELgLgZnFrdWKf2cx09Zd+OEHBCBwAgKj4lOVY8X/CQYREyCwOoGRxa0qVtWKf2M5s9B2dfb4DwEIHERg" +
             "RMhcoLLfmXiNRnkHuUAzEIDA6gRGhSyKmL2Pi2Mz4ZpZaLv6GOA/BCCwk8DonmRR8GL62JojQ8x2Dg7VIQCBMQIjEVn1TKZ+7zvI" +
             "jvVMKQhAAAIHEYhC1ntUSSfyY8RVvT/ITJqBAAQgUBMYici8tgtZFDz/Lh7TOTT4QwACEHgpgREh8zL6O94AyI691HAahwAEIBCj" +
             "rF4EpSIV58JUCJkn49yCAATeTmBLRBb/LVx2N5NFsW8fRjqEwBoEqmUWre+VTJVaxjZiHZZfrHFu4SUETkNgRHS8THaHsvfdaRzF" +
             "EAhA4PoEsiUWve/U60rQ2C32+ucHHkAAAhCAAAQgAAEIQAACEIAABCAAAQhAAAIQgMCFCfT2EGvtcnFhtzEdAhC4EwFfC5b5pMd6" +
             "oncnLvgCAQhciICLVbaeLApZfARpZO3ZhRBgKgQgcHUCcdV+tvtr3N1i5LGmq/PAfghA4IIEELILDhomQwACXyVQPfztpfS4fU9q" +
             "yVkEAQicigBCdqrhwBgIQGALgSziqqIw5si2EKYOBCDwcgIqTnFPMb1TiZC9fDjoAAIQ2EIAIdtCjToQgMApCegEfuszk/2nHEKM" +
             "ggAEEDLOAQhAAAIQgAAEIAABCEAAAhCAAAQgAAEIQAACEIAABCAAAQhAYB+B+PB39T8rYw+je4u9qt193lIbAhC4JYFKmGa/Vziz" +
             "9UcF8paDgFMQgMB2AlE84v+e9EeM9P9XWk8jjxu9qt3tnlITAhC4LYFMcNzZlmDF5yp1W+sodvZeF8zuafe2A4FjEIDAdgK6W0U1" +
             "R6ZpXyyX9f6qdrd7Sk0IQOC2BHrRURZRVemlp6G99HO2z9jubQcCxyAAge0EMlFx4fD0UefJNB3NhOZV7W73lJoQgMBtCWRb8Wja" +
             "mP1jEQdS7WbxqnZvOxA4BgEIbCegc1mxJRe0SshaW/K8qt3tnlITAhC4LYFKcOLyi5hKjiy90DkyTUU9Zd3S7m0HAscgAIF9BFRY" +
             "PNKqRC4uvWj1/Kp293lLbQhA4JYEsjVhGkWZ45pi6lINhfOqdm85CDgFAQgcQyCu7I8tRgGr3rcseFW7x3hNKxCAwK0IqEiNrN/S" +
             "pRnZDYBXtXsr+DgDAQhAAAIQgAAEIAABCEAAAhCAAAQgAAEIQAACEIAABCAAgWUJ6PY8BqK3PizCyur7cW1Hy+7te9lBw3EIQOCr" +
             "BEbFJePmdStBatVxweyJYksoGUsIQAAC3yHQerg7rhFriVX2yJI+GaBbA+3tm+GDAAQg8CWB1kPjiqnasjp7kLz3cLk/lG59xPf+" +
             "WSO11k4bDCcEILA4gUzIWqKhD5RHIcqEzufJMlEc7bsniosPIe5DAAItMWlN+mvqWO2IEYWvmo/T6ExHBSHjPIUABJoEZqMin9vK" +
             "7ki2xCzOkblBs32TXnIyQwACKYERMYmbLLbms6KQVXcbszJEZJycEIDALgKatvXuQFZ3I/WuZEvIdII/pp/VDYXsJsAux6kMAQjc" +
             "h0B1xzGmjtFbFbJsPkvnxbK2qiisNS9Hanmf8w5PIPASAioSI/uKtQypNlP0Oq0NGnt9vwQAjUIAAtcnUIlHXBQbvexFR9Vmit5e" +
             "r63Yb6+v69PHAwhAAAIQgAAEIAABCEAAAhCAAAQgAAEIQAACEIAABCAAAQhAoE+geiQp1qzK+Nqz3iLZvhWUgAAEILCDwIgIVWVU" +
             "7Fqfd5hIVQhAAAJtAvEJgLjGq3p2UteB6SNM3lvvSQHGBQIQgMBhBKqtdEYeOlcjXPwQscOGh4YgAIERAqNCNjKXZv1pGsrq/ZFR" +
             "oAwEILCLQE+gelvxVFGZfY+I7RoaKkMAAqMEqojM66uQVXNkMRrLtgwatYdyEIAABKYJVJP98SHwnthlKeXInc5pY6kAAQhAICMw" +
             "I1KtVFEn+InKON8gAIG3ERgVstZcWnWXEjF72zDSEQQgMDoxPzJ5P7KRI8QhAAEIvITAqEi1JvurNkbafolTNAoBCEAAAhCAAAQg" +
             "AAEIQAACEIAABCAAAQhAAAIQgAAEIAABCEAAAhCAAAQgAAEIQAACEIAABCAAAQhAAAIQgAAEIAABCEAAAhCAAAQgAAEIQAACEIAA" +
             "BCAAAQhAAAIQgAAEIAABCEAAAhCAAAQgAAEIQAACEIAABCAAAQhAAAIQgAAEIAABCEAAAhCAAAQgAAEIQAACEIAABCAwReAnH6X/" +
             "6PH6L1O1KAwBCEDgRAR+6WHLtx+vXz2RTZgCAQhAYIrArz+F7B8/fv/Y4/UjU7UpDAEIQGADgR9+poGWDtrrdx6vnw3tWIpo31uk" +
             "Zcfs/c+H4/be63kZi8j+xuP1jcfrB0NZ78O/+uJZ19NQ69f7sLImivHHbbF69uOfLZ3lBwIQWJiAiYWJhomBz2/ZZ/+x954qmuhF" +
             "MTJBsWMuOB6NWZkferxMyL4/tGUiZeVdeLy8taNtmUDGtq0ZFUL9vPAw4joEIGAE/uLjZWngnz1fP/r4/ZeDeNixn3q8/vjx+v3H" +
             "y9LG//4Um7/y+P19j9fff362MlbfhOy7A16LoEycLPKytvymwPc83v/B85iJ3Pc+67stJorWh9U1MXRb/u+zDfts9sS+Qre8hQAE" +
             "7k7AJuVNHP7P42XCYWLx75/C4MJkAmRC8S+ex//Z87OVNzEyITLR8on+//H8bHXiz6886//M4/evPd9/8fhtQvWtx8uEyduy76xt" +
             "E0Vr+58+y5u91q7apn1J13yEAATuSsBTPRMYi3hiqmfC8C+f4uHC9e+en3/hKSZ/+hQbi4hMbH7zefybz88qLp4u/qencP23x2+L" +
             "BK2ct+WR3I8/23IR/e3n57/5bPvfim0I2V3PUvyCQIeAzzFZKve3nmJigmKiYMJkUZpFaH9NPvtE/u89j//y47eLnJX/6Wd5vWNp" +
             "aaMd99fffrz/gWfZ/xBE0Pr3uTsTWPvs0eLPPd7/xuP1J2KbCyGDDgEILEbA7ziaCLg4WHr3E09x8Tmov/r8bOJh4md3Ik3oTLAs" +
             "qjORsXkvF0avbyKlP37z4H89Dlj6GJdomHj5vJi1+8Xj9Zeeff2bZ/sWzf2jx8ttc1vctsWGEHchAAEnYGJir7/weNmEuX/24zpx" +
             "X322CX8XFp3o97ZcyP7BU6CsnM2L+Y/e7XSxM0GzH48WLYq0vvyzT/Sr7YwyBCCwCAETIBcAFwf7bPNXLh7ZZ8djImLi5ncOvS2v" +
             "7+X8ZoBFXi5A2YJZFy8rY+1GoXP7rIyJmQoXQrbISYubEPgEAU87ffGrC1kUqU/YRZ8QgAAENhGwRbKWUlpUxQ8EIACByxHw1I9n" +
             "MC83dOc2+P8BipnMHXM09SIAAAAASUVORK5CYII=";
        #endregion

        /// <summary>
        /// rectの中にpointが入っているかどうかを判定
        /// </summary>
        /// <param name="point"></param>
        /// <param name="rect"></param>
        /// <returns></returns>
        public static bool IsInRectangle( Point point, Rectangle rect ) {
            if ( rect.X <= point.X && point.X <= rect.X + rect.Width ) {
                if ( rect.Y <= point.Y && point.Y <= rect.Y + rect.Height ) {
                    return true;
                }
            }
            return false;
        }

        public static bool Edited {
            get {
                return m_edited;
            }
            set {
                bool old = m_edited;
                m_edited = value;
                if ( EditedChanged != null ) {
                    EditedChanged( typeof( AppManager ), new EventArgs() );
                }
            }
        }

        public static string VERSION {
            get {
#if DEBUG
                return GetAssemblyVersion( typeof( Form1 ) ) + " (build:debug)";
#else
                return GetAssemblyVersion( typeof( Form1 ) ) + " (build:release)";
#endif
            }
        }

        private static string GetAssemblyVersion( Type t ) {
            Assembly a = Assembly.GetAssembly( t );
            AssemblyFileVersionAttribute afva = (AssemblyFileVersionAttribute)Attribute.GetCustomAttribute( a, typeof( AssemblyFileVersionAttribute ) );
            return afva.Version;
        }

        /// <summary>
        /// pictureBox1の行の表示状態を表す配列を取得します。
        /// </summary>
        /// <returns></returns>
        public static int[] GetTimeLineLanes() {
            List<int> ret = new List<int>();
            // vsq
            if ( SaveData.m_group_vsq.Folded ) {
                ret.Add( 1 );
            } else {
                ret.Add( SaveData.m_group_vsq.Count + 1 );
            }
            // character
            for ( int i = 0; i < SaveData.m_groups_character.Count; i++ ) {
                if ( SaveData.m_groups_character[i].Folded ) {
                    ret.Add( 1 );
                } else {
                    ret.Add( SaveData.m_groups_character[i].Count + 1 );
                }
            }
            // telop
            if ( SaveData.TelopListFolded ) {
                ret.Add( 1 );
            } else {
                ret.Add( MaxTelopLanes + 1 );
            }
            // another image
            if ( SaveData.m_group_another.Folded ) {
                ret.Add( 1 );
            } else {
                ret.Add( SaveData.m_group_another.Count + 1 );
            }
            // plugin
            if ( SaveData.m_group_plugin.Folded ) {
                ret.Add( 1 );
            } else {
                ret.Add( SaveData.m_group_plugin.Count + 1 );
            }
            return ret.ToArray();
        }

        /// <summary>
        /// アプリケーションのメイン エントリ ポイントです。
        /// </summary>
        [STAThread]
        static void Main( string[] argv ) {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault( false );
#if !DEBUG
            try {
#endif
                string file = "";
                if ( argv.Length > 0 ) {
                    file = argv[0];
                }
                Form1 form1 = null;
                if ( File.Exists( file ) ) {
                    form1 = new Form1( file );
                } else {
                    form1 = new Form1( "" );
                }
                Application.Run( form1 );
                Common.LogClose();
#if !DEBUG
            } catch ( Exception e ) {
                Common.LogPush( e );
                Common.LogClose();
            }
#endif
        }

        static AppManager() {
            using ( MemoryStream ms = new MemoryStream( Convert.FromBase64String( _AUTHOR_LSIT ) ) ) {
                m_author_list = new Bitmap( ms );
            }
        }

        /// <summary>
        /// 現在保持しているコマンドバッファをクリアします。
        /// </summary>
        public static void ClearCommandBuffer() {
            m_commands.Clear();
            m_command_position = -1;
        }

        /// <summary>
        /// 次回アンドゥ処理されるコマンドの種類を調べます
        /// </summary>
        /// <returns></returns>
        public static CommandType GetNextUndoCommandType() {
            if ( IsUndoAvailable ) {
                return m_commands[m_command_position].type;
            } else {
                return CommandType.nothing;
            }
        }

        /// <summary>
        /// アンドゥ処理を行います
        /// </summary>
        public static void Undo() {
            if ( IsUndoAvailable ) {
                Command run = m_commands[m_command_position];
                Command inv = SaveData.Execute( run );
                m_commands[m_command_position] = inv;
                m_command_position--;
            }
        }

        /// <summary>
        /// 次回リドゥ処理されるコマンドの種類を調べます
        /// </summary>
        /// <returns></returns>
        public static CommandType GetNextRedoCommandType() {
            if ( IsRedoAvailable ) {
                return m_commands[m_command_position + 1].type;
            } else {
                return CommandType.nothing;
            }
        }

        /// <summary>
        /// リドゥ処理を行います
        /// </summary>
        public static void Redo() {
            if ( IsRedoAvailable ) {
                Command run = m_commands[m_command_position + 1];
                Command inv = SaveData.Execute( run );
                m_commands[m_command_position + 1] = inv;
                m_command_position++;
            }
        }

        /// <summary>
        /// リドゥ操作が可能かどうかを表すプロパティ
        /// </summary>
        public static bool IsRedoAvailable {
            get {
                if ( m_commands.Count > 0 && 0 <= m_command_position + 1 && m_command_position + 1 < m_commands.Count ) {
                    return true;
                } else {
                    return false;
                }
            }
        }

        /// <summary>
        /// アンドゥ操作が可能かどうかを表すプロパティ
        /// </summary>
        public static bool IsUndoAvailable {
            get {
                if ( m_commands.Count > 0 && 0 <= m_command_position && m_command_position < m_commands.Count ) {
                    return true;
                } else {
                    return false;
                }
            }
        }
        
        /// <summary>
        /// コマンドバッファに指定されたコマンドを登録します
        /// </summary>
        /// <param name="command"></param>
        public static void Register( Command command ) {
            if ( m_command_position == m_commands.Count - 1 ) {
                // 新しいコマンドバッファを追加する場合
                m_commands.Add( command );
                m_command_position = m_commands.Count - 1;
            } else {
                // 既にあるコマンドバッファを上書きする場合
                //m_commands[m_command_position + 1].Dispose();
                m_commands[m_command_position + 1] = command;
                for ( int i = m_commands.Count - 1; i >= m_command_position + 2; i-- ) {
                    m_commands.RemoveAt( i );
                }
                m_command_position++;
            }
        }

        public static Bitmap author_list {
            get {
                return (Bitmap)m_author_list.Clone();
            }
        }
    }

}
