/*
 * VsqMaster.java
 * Copyright (c) 2008 kbinani
 *
 * This file is part of jp.sourceforge.lipsync.vsq.
 *
 * jp.sourceforge.lipsync.vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * jp.sourceforge.lipsync.vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package jp.sourceforge.lipsync.vsq;

import java.io.*;

/**
 *
 * @author kbinani
 */
public class VsqMaster implements Cloneable {
    public int PreMeasure;

    public Object clone() {
        VsqMaster res = new VsqMaster( PreMeasure );
        return res;
    }

    /**
     * プリメジャー値を指定したコンストラクタ
     */
    public VsqMaster( int pre_measure ) {
        this.PreMeasure = pre_measure;
    }

    /**
     * テキストファイルからのコンストラクタ
     * @param sr 読み込み元
     * @param last_line 最後に読み込んだ行が返されます
     * @throws java.lang.Exception
     */
    public VsqMaster( TextMemoryStream sr, TextResult last_line ) {
        PreMeasure = 0;
        String[] spl;
        last_line.set( sr.readLine() );
        while ( !last_line.get().startsWith( "[" ) ) {
            spl = last_line.get().split( "=" );
            if ( spl[0].equals( "PreMeasure" ) ) {
                this.PreMeasure = Integer.valueOf( spl[1] );
                break;
            }
            if ( sr.peek() < 0 ) {
                break;
            }
            last_line.set( sr.readLine() );
        }
    }

    /**
     * インスタンスの内容をテキストファイルに出力します
     * @param sw出力先
     */
    public void write( TextMemoryStream sw ){
        sw.writeLine( "[Master]" );
        sw.writeLine( "PreMeasure=" + PreMeasure );
    }

}
