/*
 * VsqEventIterator.java
 * Copyright (c) 2008 kbinani
 *
 * This file is part of jp.sourceforge.lipsync.vsq.
 *
 * jp.sourceforge.lipsync.vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * jp.sourceforge.lipsync.vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package jp.sourceforge.lipsync.vsq;

import java.util.*;

/**
 *
 * @author kbinani
 */
public class VsqEventIterator implements Iterator {
    private Vector<VsqEvent> m_list;
    private int m_index = 0;
    private VsqEventIteratorMode m_mode;

    public VsqEventIterator( Vector<VsqEvent> list, VsqEventIteratorMode mode ) {
        m_list = list;
        m_index = 0;
        m_mode = mode;
    }

    public void remove() {
        m_list.remove( m_index );
    }

    public Object next() {
        int last = m_index;
        for ( m_index = last; m_index < m_list.size(); m_index++ ) {
            VsqEvent ret = m_list.get( m_index );
            if ( m_mode == VsqEventIteratorMode.All ) {
                return ret;
            } else if ( m_mode == VsqEventIteratorMode.Anote ) {
                if ( ret.ID.type == VsqIDType.Anote ) {
                    return ret;
                } else {
                    continue;
                }
            } else if ( m_mode == VsqEventIteratorMode.Singer ) {
                if ( ret.ID.type == VsqIDType.Singer ) {
                    return ret;
                } else {
                    continue;
                }
            }
        }
        return null;
    }

    public boolean hasNext() {
        if ( m_mode == VsqEventIteratorMode.All ) {
            return (m_index + 1 < m_list.size());
        } else {
            for ( int i = m_index; i < m_list.size(); i++ ) {
                VsqEvent ret = m_list.get( i );
                if ( m_mode == VsqEventIteratorMode.Anote ) {
                    if ( ret.ID.type == VsqIDType.Anote ) {
                        return true;
                    } else {
                        continue;
                    }
                } else if ( m_mode == VsqEventIteratorMode.Singer ) {
                    if ( ret.ID.type == VsqIDType.Singer ) {
                        return true;
                    } else {
                        continue;
                    }
                }
            }
            return false;
        }
    }

}
