/*
 * VsqBarLineEnumeration.java
 * Copyright (c) 2008 kbinani
 *
 * This file is part of jp.sourceforge.lipsync.vsq.
 *
 * jp.sourceforge.lipsync.vsq is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * jp.sourceforge.lipsync.vsq is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
package jp.sourceforge.lipsync.vsq;

import java.util.*;

/**
 *
 * @author kbinani
 */
public class VsqBarLineEnumeration implements Enumeration {
    Vector<TimeSigTableEntry> TimeSigTable;
    int end_clock;
    int m_index = 0;
    int m_last_clock = -1;

    public VsqBarLineEnumeration( Vector<TimeSigTableEntry> time_sig_table, int t_end_clock ) {
        TimeSigTable = time_sig_table;
        end_clock = t_end_clock;
        m_index = 0;
        m_last_clock = -1;
    }

    public boolean hasMoreElements() {
        if ( m_last_clock < 0 ) {
            return true;
        }
        for ( int i = m_index; i < TimeSigTable.size(); i++ ) {
            int denominator = TimeSigTable.get( i ).Denominator;
            int numerator = TimeSigTable.get( i ).Numerator;
            int local_clock = TimeSigTable.get( i ).Clock;
            int bar_count = TimeSigTable.get( i ).BarCount;
            int clock_step = 480 * 4 / denominator;
            int mod = clock_step * numerator;
            int bar_counter = bar_count - 1;
            int t_end = end_clock;
            if ( i + 1 < TimeSigTable.size() ) {
                t_end = TimeSigTable.get( i + 1 ).Clock;
            }
            int t_start = m_last_clock + clock_step;
            for ( int clock = t_start; clock < t_end; clock += clock_step ) {
                if ( (clock - local_clock) % mod == 0 ) {
                    bar_counter++;
                    return true;
                } else {
                    return true;
                }
            }
        }
        return false;
    }

    public Object nextElement() {
        if ( m_last_clock < 0 ) {
            m_last_clock = 0;
            return new VsqBarLineType( 0, true, TimeSigTable.get( 0 ).Denominator, TimeSigTable.get( 0 ).Numerator, 0 );
        }
        int last = m_index;
        for ( m_index = last; m_index < TimeSigTable.size(); m_index++ ) {
            int denominator = TimeSigTable.get( m_index ).Denominator;
            int numerator = TimeSigTable.get( m_index ).Numerator;
            int local_clock = TimeSigTable.get( m_index ).Clock;
            int bar_count = TimeSigTable.get( m_index ).BarCount;
            int clock_step = 480 * 4 / denominator;
            int mod = clock_step * numerator;
            int bar_counter = bar_count - 1;
            int t_end = end_clock;
            if ( m_index + 1 < TimeSigTable.size() ) {
                t_end = TimeSigTable.get( m_index + 1 ).Clock;
            }
            int t_start = m_last_clock + clock_step;
            for ( int clock = t_start; clock < t_end; clock += clock_step ) {
                if ( (clock - local_clock) % mod == 0 ) {
                    bar_counter++;
                    m_last_clock = clock;
                    return new VsqBarLineType( clock, true, denominator, numerator, bar_counter );
                } else {
                    m_last_clock = clock;
                    return new VsqBarLineType( clock, false, denominator, numerator, bar_counter );
                }
            }
        }
        return null;
    }


    /*private Object imp_nextElement() {
    int local_denominator;
    int local_numerator;
    int local_clock;
    int local_bar_count;
    int clock_step;
    for ( int i = 0; i < TimeSigTable.size(); i++ ) {
    local_denominator = TimeSigTable.get( i ).Denominator;
    local_numerator = TimeSigTable.get( i ).Numerator;
    local_clock = TimeSigTable.get( i ).Clock;
    local_bar_count = TimeSigTable.get( i ).BarCount;
    clock_step = 480 * 4 / local_denominator;
    int mod = clock_step * local_numerator;
    int bar_counter = local_bar_count - 1;
    int t_end = end_clock;
    if ( i + 1 < TimeSigTable.size() ) {
    t_end = TimeSigTable.get( i + 1 ).Clock;
    }
    for ( int clock = local_clock; clock < t_end; clock += clock_step ) {
    if ( (clock - local_clock) % mod == 0 ) {
    bar_counter++;
    return new VsqBarLineType( clock, true, local_denominator, local_numerator, bar_counter );
    } else {
    return new VsqBarLineType( clock, false, local_denominator, local_numerator, bar_counter );
    }
    }
    }
    }*/
}
