﻿/*
 * IPlugin.cs
 * Copyright (c) 2007, 2008 kbinani
 *
 * This file is part of LipSync.
 *
 * LipSync is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * LipSync is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.Collections.Generic;
using System.Text;
using System.Drawing;
using System.Windows.Forms;

namespace Plugin {

    
    public class Constants {
        /// <summary>
        /// エントリーごとの設定が可能なプラグインであることを表します。
        /// </summary>
        public const ulong LS_ENABLES_ENTRY_SETTING = 1;
        /// <summary>
        /// このプラグインが、設定用ウィンドウを持たないことを表します。
        /// </summary>
        public const ulong LS_NO_EVENT_HANDLER = 2;
        /// <summary>
        /// このプラグインが、キャラクタ描画用のプラグインであることを表します。
        /// </summary>
        public const ulong LS_TYPE_CHARACTER = 4;
    }


    /// <summary>
    /// メイン画面で使用されている変数へのプロキシを提供
    /// </summary>
    public class Proxy {

    }


    /// <summary>
    /// プラグイン用のインターフェースを定義します
    /// </summary>
    public interface IPlugin {

        /// <summary>
        /// プラグインの名称
        /// </summary>
        string Name {
            get;
        }


        /// <summary>
        /// プラグインの簡潔な説明文。
        /// </summary>
        string Abstract {
            get;
        }


        /// <summary>
        /// フレームに加工を施す関数
        /// </summary>
        /// <param name="frame">加工の対象</param>
        /// <param name="time">ビデオの先頭からの時刻(秒)</param>
        /// <param name="e_begin">エントリの開始時刻</param>
        /// <param name="e_body">エントリの終了時刻</param>
        /// <param name="e_end">エントリの設定値</param>
        void Apply( ref Bitmap frame, float time, float e_begin, float e_end, ref string e_body );


        /// <summary>
        /// プラグイン用の設定値を格納した文字列を指定します。
        /// </summary>
        /// <returns></returns>
        string Config {
            get;
            set;
        }


        /// <summary>
        /// メイン画面の言語設定が変更されたとき呼び出されます。
        /// </summary>
        /// <param name="language_code"></param>
        void ApplyLanguage( string language_code );


        /// <summary>
        /// このプラグインの設定メニューが押された時呼び出されます。
        /// </summary>
        DialogResult BaseSetting();


        /// <summary>
        /// エントリーごとの設定メニューが押された時呼び出されます。
        /// エントリーごとの設定は、ぷらぐいん側で任意に設定できます。
        /// </summary>
        /// <param name="entry_config">編集するエントリの設定</param>
        DialogResult EntrySetting( ref string entry_config );


        /// <summary>
        /// このプラグインのタイプを指定します。
        /// </summary>
        ulong Type {
            get;
        }


        /// <summary>
        /// キャラクタ描画関数。
        /// </summary>
        /// <param name="g">キャラクタの描画先</param>
        /// <param name="size">gのサイズ</param>
        /// <param name="time">ビデオの先頭からの時刻</param>
        /// <param name="mouth">時刻timeにおける口の形がコンマ区切りで列挙されている</param>
        /// <param name="Reserved">（予約）</param>
        void Render( Graphics g, Size size, float time, string mouth, string Reserved );
    
    }
}
