﻿/*
 * SwfWriter.cs
 * Copyright (c) 2008-2009 kbinani
 *
 * This file is part of Boare.Lib.Swf.
 *
 * Boare.Lib.Swf is free software; you can redistribute it and/or
 * modify it under the terms of the BSD License.
 *
 * Boare.Lib.Swf is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 */
using System;
using System.IO;
using System.Collections.Generic;

namespace Boare.Lib.Swf {

    using UI8 = System.Byte;
    using UI32 = System.UInt32;
    using UI16 = System.UInt16;
    using SI8 = System.SByte;
    using SI16 = System.Int16;
    using SI32 = System.Int32;

    public class SwfWriter : IDisposable {

        private const UI8 m_version = 0x6;
        private UI16 m_frame_rate;
        private UI16 m_frame_count;
        private FileStream m_stream;

        public SwfWriter( FileStream s ) {
            m_stream = s;

            // swf header
            s.WriteByte( 0x46 );    // Signature
            s.WriteByte( 0x57 );    // Signature
            s.WriteByte( 0x53 );    // Signature
            s.WriteByte( m_version );   // Version
            s.WriteByte( 0x0 );     // FileLength
        }


        public void Close() {
            if ( m_stream != null ) {
                m_stream.Close();
            }
        }


        public void Dispose() {
            Close();
        }


        public static int GetEncodedU32( byte[] pos ) {
            int result = pos[0];
            if ( (result & 0x00000080) == 0x0 ) {
                return result;
            }
            result = (result & 0x0000007f) | pos[1] << 7;
            if ( (result & 0x00004000) == 0x0 ) {
                return result;
            }
            result = (result & 0x00003fff) | pos[2] << 14;
            if ( (result & 0x00200000) == 0x0 ) {
                return result;
            }
            result = (result & 0x001fffff) | pos[3] << 21;
            if ( (result & 0x10000000) == 0x0 ) {
                return result;
            }
            result = (result & 0x0fffffff) | pos[4] << 28;
            return result;
        }

    }

}
