#!/usr/bin/perl
# $Id: latest-docs.pl,v 1.13 2007/02/20 14:55:20 mdk Exp $
#
# news.m4 鿷ʸФ뤿 Perl5 script.
# index.html, updated-docs.html, Monthly Informational mail 
# ˻Ȥޤ
#

use strict;
use Time::Local;
use DB_File;
use lib ("../bin", "../../bin"); # jfadmlib.pm Τǥ쥯ȥ
use jfadmlib;
use Jcode;

my $indexfile = '../jfindex.db';
if ((! -r $indexfile) and (-r $ARGV[3])) {
    $indexfile = $ARGV[3];
} elsif (! -r $indexfile) {
    die;
}

# news.m4 λ
my $news_m4 = $ARGV[0];

# Ƕβ֤ doc ɽ뤫
my $recentdays = $ARGV[1];

# ¤Ǥɽ doc ο
my $minitems = $ARGV[2];

# ɽ doc κ¤ο
my $maxitems = 512; #  (߻¾¤ʤ)

my %hash;
my $H = tie(%hash, 'DB_File', $indexfile, O_RDONLY, 0644, $DB_BTREE) or die;
my %updated;

my $prevline = '';
my $i = 0;
my $now = time;
my $sec = 60 * 60 * 24 * $recentdays;
my $doc;

open(N, $news_m4) or die;
while (<N>) {
    
    if ($prevline) {
	my $data;
	my $kdoc_info = '../docs/' . $doc . '.info';
	
	if (-r $kdoc_info) {
	    $data = get_kdoc_cont($kdoc_info);
	} else {
	    $doc =~ s,/index$,,; # DocBook
	    $doc =~ s,.*/,,;
	    $data = get_ent($H, $doc, 'CONT');		
	}
	
	print $prevline;
	s/\)\s*$//;
	print;
	if ($data) {
	    print ",\n        \`\`$data\'\')\n";;
	} else {
	    print ")\n";
	}
	$prevline = '';
	next;
    }
    
    if (/^\s*_(NEW|UPD)_DOC\((.*)\.(html|txt),(\d+\/\d+\/\d+),/) {
	$doc = $2;
	if ($updated{$doc}) {
	    $prevline = '';
	    next;
	}

	$i++;
	last if $i > $maxitems;

	$updated{$doc} = 1;
	$prevline = $_ if (calc_date($4, $now, $sec)) or ($i <= $minitems);
    }
    
}
close N;

sub get_kdoc_cont {
    my ($kdoc_info) = @_;
    my $data;
    local $_;

    return unless open(INFO, $kdoc_info);
    while (<INFO>) {
	if (/^CONT: (.+)$/) {
	    $data = $1;
	    Jcode::convert(\$data, 'euc');
	    last;
	}
    }
    close INFO;
    return $data;
}
       
sub calc_date {
    my ($d, $now, $sec) = @_;
    my @p = split(/\//, $d);
    foreach (@p) {
	s/^0//;
    }
    my $t = timelocal(0, 0, 0, $p[2], $p[1]-1, $p[0]-1900);
    return 1 if $now - $t < $sec;
    return 0;
}
