#! /usr/bin/perl -w
# $Id: jf-in-progress.pl,v 1.13 2009/05/17 15:47:27 mdk Exp $
#
# LDP  sorted_howtos.dat ȡͽ򵭽ҤꥹȤʹԾΥݡȤ
# Ϥ뤿 Perl5 script.  JF-in-Progress.html ˻Ȥޤ
#
# ¹ԤˤäƤϡsorted_howtos.dat, reserved.list, obsoleted.LDP 
# LISTDIR ˡjfindex.db (̾ JF ݥȥ make Ԥ
# TOPDIR ˺)  TOPDIR ɬפǤϼ¹Ի option
# switch ѹ뤳ȤǤޤ
#

require 5.003;
use strict;
use vars qw(%opts);
use DB_File;
use Getopt::Std;

getopts('d:l:hmorM', \%opts);

my $JFINDEX = "../../jfindex.db";
$JFINDEX = $opts{'d'} if $opts{'d'};

my $LISTDIR = "../../lists";
$LISTDIR = $opts{'l'} if $opts{'l'};

unless ($opts{'h'} || $opts{'o'} || $opts{'m'} || $opts{'r'}) {
  print <<"USAGE";
  option -d index
         -h : output HOWTO list.
         -m : output mini-HOWTO list.
         -o : output docs unmaintained in LDP.
         -r : outout NON-LDP reserved docs.
         -M : use M4 format.
USAGE
}

#############################################################################
# ɬפ˱ƽ񤭴Ƥ
#
use lib ("../../bin");                      # jfadmlib.pm Τǥ쥯ȥ
my $LDPINDEX      = "$LISTDIR/sorted_howtos.dat"; # LDP sorted_howtos.dat
my $RESERVE_INDEX = "$LISTDIR/reserved.list";     # ͽꥹ
my $OBSOLETED     = "$LISTDIR/obsoleted.LDP";     # LDP ǥƥʥ󥹤ʤ
                                                  # ʤäʪΥꥹ
my %status_mark =
    ('ng' => '',
     'soso' => '',
     'ok' => '',
     'good' => '',

     'reserved' => '',
     'draft' => '',
     'suspended' => '');

#############################################################################

use jfadmlib;

#
# jfindex.db  tie 롣
#
my (%hash, $H);
$H = tie(%hash, 'DB_File', $JFINDEX, O_RDONLY, 0644, $DB_BTREE) or die;

#
# LDP κǿΥꥹȤѿ˳Ǽ.
#
use ldp;
my ($NAMES, $authors, $update, $desc, $class, $docbook) = 
  ldp::read_sorted_howtos($LDPINDEX);

# my ($NAMES, $authors, $update, $desc, $class) = 
#  ldp::get_LDP_list($LDPINDEX);

#
# ʲ ޤǤꤷ̰Ƥ HOWTO  INDEX 
# ޤȤ˥Ȥ򳰤.
#
#  ($NAMES, $authors, $update, $desc, $class) = 
#   &add_special_docs($NAMES, $authors, $update, $desc, $class);

#
# $LO_LDP  LDP ǡؤΥե.
#
my $LO_LDP = [$authors, $update, $desc, $class, $docbook];

#
# ͽꥹȤɤ߹ǥǡ $reserve ȤꥹȤؤΥե󥹤
# ǼƤ.
#
my @k = &get_reserved_statement($RESERVE_INDEX);
my $reserve = \@k;

#
# ϥեޥå.
#
my ($doc, $comments, $m4_link);
format STD_M4 =
@<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< @<<<<<<<<< @<<<<<<<<< @<<<<<<<<< @<
$m4_link . "(" . $doc . "," . $LO_LDP->[4]->{$doc} . ")", $LO_LDP->[1]->{$doc}, $comments->[1], $comments->[2],$comments->[0]
~~  ^>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
    $comments->[3]
.

format STDOUT =
@<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< @<<<<<<<<< @<<<<<<<<< @<<<<<<<<< @<
$doc, $LO_LDP->[1]->{$doc}, $comments->[1], $comments->[2], $comments->[0], 
~~  ^>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>
    $comments->[3]
.

if ($opts{'M'}) {
  select(STDOUT);
  $~ = "STD_M4";
}


if ($opts{'h'}) {
#----------------------------
# LDP HOWTOs ơ
#----------------------------
  print "  ե̾                                              LDPǿ        \n";
  print "--------------------------------------------------------- ---------- ---------- ---------- --\n";
  foreach $doc (sort @$NAMES) {
    next unless $LO_LDP->[3]->{$doc} eq "HOWTO";
    $comments = &get_comment_statement($doc, $H, $LO_LDP, $reserve);
    $m4_link = "_HL";
    write;
  }
}

if ($opts{'o'}) {
#-----------------------------------
# LDP unmaintained ơ
#-----------------------------------
  print "  ե̾                        \n";
  print "  -------------------------------- ----------\n";
  open(OBS, $OBSOLETED) or die "cant open $OBSOLETED";
  my @ob_list;
  while (<OBS>) {
    next if /^#/;
    chomp;
    push(@ob_list, $_);
  }
  close OBS;

  foreach $doc (@ob_list) {
    my $name = get_ent($H, $doc, "NAME");
    if ($name) {
      my $ob_jdat = get_ent($H, $doc, "JDAT");
      $ob_jdat = "unknown" unless $ob_jdat;
      printf("  %-32s %-10s\n",$doc, $ob_jdat);
    }
  }
}

if ($opts{'r'}) {
#-------------------------------------
# LDP ʳʸͽ󥹥ơ
#-------------------------------------

#  print "          ʸ̾                ͽ     \n";
#  print "  ---------------------------- ---------- -- ---------------------------\n";
  print "                   ʸ̾                   ͽ  \n";
  print "  ---------------------------------------- ---------- ----\n";
  foreach my $r_name (keys %{$reserve->[0]}) {
    next if $LO_LDP->[1]->{$r_name};
    my $mk = get_reserve_mark($r_name, $reserve);
#    printf("  %-40s %-10s %-s %-s\n",$r_name, $reserve->[1]->{$r_name}, $mk,
#	   $reserve->[0]->{$r_name});
    printf("  %-40s %-10s %-s\n",$r_name, $reserve->[1]->{$r_name}, $mk);
  }
}

exit;


###############################################################################
# sub routines
###############################################################################

sub add_special_docs {
#
# ޤǤꤷ̰Ƥ HOWTO (դ) Ф
# ΤݤʤΤǡľܤ˥ǡ򵭽Ҥ(δؿ̤Ѥ
# ʤäƤΤǡɬפ˱ƻȤȡ)
# Ūˤϡget_LDP_list 줿̤Ϥơ˥ǡɲ
# 褦˻Ȥ
#
  my ($NAMES, $authors, $update, $desc, $class) = @_;

  my $bn          = "High-Availability-HOWTO";
  $authors->{$bn} = "Harald Milz <hm\@seneca.muc.de>";
  $update->{$bn}  = "";
  $desc->{$bn}    = "";
  $class->{$bn}   = "SPEC";
  push(@$NAMES, $bn);
  
  $bn             = "Graphics mini-HOWTO";
  $authors->{$bn} = "Michael J. Hammel <mjhammel\@graphics-muse.org>";
  $update->{$bn}  = "";
  $desc->{$bn}    = "";
  $class->{$bn}   = "SPEC";
  push(@$NAMES, $bn);

  return ($NAMES, $authors, $update, $desc, $class);
}

sub get_reserved_statement {
#
# ͽꥹȤɤ߹ǡĤΥϥåؤΥե󥹤֤
#
# $r_trns: ʸ̾򥭡ȤʸͽԤ̾ΥϥåؤΥե
# $r_date: ʸ̾򥭡Ȥʸͽ (YYYY/MM/DD)Υե
# $r_stat: ʸ̾򥭡ȤʸΥơΥϥåؤΥե
#          (P.* ... Progress  D.* ... Draft ʤɡ)
# $r_note: ʸ̾򥭡ȤʸΥΥϥåؤΥե
#
  my $RESERVE_INDEX = $_[0];
  my ($r_name, $r_trns, $r_note, $r_date, $r_stat);
  open(RES, $RESERVE_INDEX) or die "cant open $RESERVE_INDEX";
  while (<RES>) {
    chomp;
    if (/^$/ && $r_name) {
      $r_name = "";
      next;
    }
    if (/^NAME:\s*(.*)$/) {
      $r_name = $1;
      $r_name =~ s/\s*$//;
      next;
    }
    if ($r_name && /^TRNS:\s*(.*)$/) {
      $r_trns->{$r_name} = $1;
      $r_trns->{$r_name} =~ s/\s*$//;
      next;
    }
    if ($r_name && /^PDAT:\s*(.*)$/) {
      $r_date->{$r_name} = $1;
      $r_date->{$r_name} =~ s/\s*$//;
      next;
    }
    if ($r_name && /^NOTE:\s*(.*)$/) {
      $r_note->{$r_name} = $1;
      $r_note->{$r_name} =~ s/\s*$//;
      next;
    }
    if ($r_name && /^STAT:\s*(.*)$/) {
      $r_stat->{$r_name} = $1;
      $r_stat->{$r_name} =~ s/\s*$//;
      next;
    }
  }
  close RES;
  return ($r_trns, $r_date, $r_stat, $r_note);
}

#
# Ϥκݤ˻ȤʬΥơ򤢤魯
# դƤ
#
sub get_comment_statement {
  my ($doc, $H, $LDP, $reserve) = @_;
  my $bdat = get_ent($H, $doc, "BDAT");
  my $jdat = get_ent($H, $doc, "JDAT");
  $bdat = $bdat . "/00" if $bdat =~ /^\d\d\d\d\/\d\d$/;
  $jdat = $jdat . "/00" if $jdat =~ /^\d\d\d\d\/\d\d$/;
  
  my $d_ldp = $LDP->[1]->{$doc};
  my $d_jf  = $bdat;
  unless ($bdat) {
    $d_jf = $jdat;
  }
  $d_ldp =~ s,/,,g;
  $d_jf  =~ s,/,,g;

  my $mk = "??";
  my $resperson = "";
  if ($d_jf eq 0) {
      $mk = $status_mark{'ng'};
  } elsif ($d_jf < $d_ldp) {
      $mk = $status_mark{'ok'};
  } else {
      $mk = $status_mark{'good'};
  }
  if ($reserve->[0]->{$doc} and ($mk ne $status_mark{'good'})) {
      $mk = &get_reserve_mark($doc, $reserve);
      $bdat = "Reserved \@";
      $jdat = $reserve->[1]->{$doc};
#      $resperson = $reserve->[0]->{$doc};
  }
  
  $bdat = '' unless $bdat;
  $jdat = '' unless $jdat;
  
  return [$mk, $bdat, $jdat, $resperson];
}

sub get_lo_kind {
  my ($hash, $kind) = @_;
  my @docs;
  while (my ($k, $v) = each %$hash) {
    next unless $k =~ /\@\@KIND$/;
    if ($v =~ /$kind/) {
      my @d = split(/\@\@/, $k);
      push(@docs, $d[0]);
    }
  }
  return \@docs;
}

#
# ʸ̾ͽϥå塢ޡΥꥹȤˤơŬ礹ޡ
# ֤ؿ
#
sub get_reserve_mark {
  my ($doc, $reserve) = @_;
  my $status = lc($reserve->[2]->{$doc});

  if(defined $status_mark{$status}){
      return $status_mark{$status};
  }

  '??';
}

# end of script.
