#!/usr/bin/perl
#
# Kernel Docs ΥСꥹȤ,
# ͥѥåȤäƹ륹ץ
#
# Х: ʸ񤬤ʤʤä̤б(^^;
#
# [Ȥ]
#
# ҤȤĤΰ: Kernel Docs ΥСꥹ
# դĤΰ: bzip2 ʥͥѥåե
#
# []
#
# $ ./upd-kdoc-list.pl ../lists/kdoc-2.6-version.list \
# ~/src/patch-2.6.2.bz2 >../lists/kdoc-2.6-version.list.new
# $ cd ../lists
# $ mv kdoc-2.6-version.list.new kdoc-2.6-version.list
#

use File::Basename;

if (@ARGV < 2) {die "$0 oldlist kernel-patch\n"};

$OLDLIST = $ARGV[0];
$K_PATCH = $ARGV[1];

$NEWKVER = basename($ARGV[1], '.bz2');
$NEWKVER =~ s/^patch-//;

unless (-f $OLDLIST) {die "$OLDLIST does not exist.\n"};
unless (-f $K_PATCH) {die "$K_PATCH does not exist.\n"};

unless ($NEWKVER =~ /^[23]\.([0246])\.([1-9][0-9]?)/) {
    die "illegal version number.\n";
}
$NEWPATCHLEVEL = $1;
$NEWSUBLEVEL   = $2;

open OL, $OLDLIST;
while (<OL>) {
    chomp;
    if (/^# latest versions of kernel docs, as of (2\.([246])\.([0-9][0-9]?))/) {
	$OLDKVER       = $1;
	$OLDPATCHLEVEL = $2;
	$OLDSUBLEBEL   = $3;
	unless ($OLDPATCHLEVEL == $NEWPATCHLEVEL &&
		++$OLDSUBLEBEL == $NEWSUBLEVEL) {
	    die "illegal version number.\n";
	}
	next;
    }
    ($VER, $FILE) = split;
    $FVER{$FILE} = $VER;
}
close OL;

print STDERR "Current kdoc version is $OLDKVER\n";
print STDERR "updating kdoc to $NEWKVER...\n";

# Ȥꤢ bzip2 ʥѥåե˷Ǥ.
#
open KP, "bzip2 -dc $K_PATCH |";
while (<KP>){
    next unless ((/^\+\+\+ b\/Documentation\/([^ \t\n]*)/) or
		 (/^\+\+\+ linux-$NEWKVER\/Documentation\/([^ \t]*)/) or
		 (/^\+\+\+ linux\/Documentation\/([^ \t]*)/));
    print STDERR "$1 updated!\n";
    $FVER{$1} = $NEWKVER;
}

print "# latest versions of kernel docs, as of $NEWKVER\n";
foreach $k (sort keys %FVER){
    printf "%-7s%s\n", $FVER{$k}, $k;
}
