#!/usr/bin/perl
#                              -*- Mode: Perl -*- 
# result.cgi
# Copyright (C) 2000: JF Project
# Created On      : Fri Sep  1 00:29:44 2000
#
# $Id: result.cgi,v 1.4 2000/09/05 21:38:47 fuku Exp $
# 
use vars qw(*in);
use DB_File;
use Fcntl;
use jfenq;
require 'cgi-lib.pl';
require 'jcode.pl';

## 󥱡ȤƤ򵭽Ҥ m4 ե
my $enqfile = "enquete-01.body";

## 󥱡ȷ̤򽸷פ DB
my $database = "enquete-01.db";

my $sep = "\@\@=";
my $color = ["#c0c0f0", "#e0e0f0", "#e0e0f0", "#e0e0f0", "#e0e0f0", "#e0e0f0"];

my ($enq, $question, $radio_item, $chkbox_item, $texts_item, $textarea)
  = jfenq::get_lo_enq($enqfile);

&ReadParse(*in);

my $debug = 0;

$in{'format'} = 1 unless $in{'format'};
$in{'format'} = 9 if $in{'email'};
$in{'split'}  = 5 unless $in{'split'};
$in{'start'}  = 0 unless $in{'start'};
$in{'datanum'} = 0 unless $in{'datanum'};
my @next = ($in{'format'}, $in{'split'}, $in{'start'});

jfenq::print_html_header("Result") unless $debug;

jfenq::print_toc($next[0], $next[1], $next[1] + $next[2], $in{'datanum'}, 1)
  if $in{'format'} == 3;

my ($H, %index);
$H = tie(%index, 'DB_File', "$database",
	 O_RDONLY, 0644, $DB_BTREE) or die;

my $summary = [];
my $offer = {};
my $name = {};
my @email_addr;
while ( my ($email, $val) = each %index ) {
  &jcode::convert(\$val,'euc');
  push(@email_addr,$email);
  my @d = split("$sep",$val);
  my @c = split(',', $d[6]);

  $name->{$email} = $d[0];
  $summary->[0]->[0]++;
  $summary->[1]->[$d[1]]++;
  $summary->[2]->[$d[2]]++;
  $summary->[3]->[$d[3]]++;
  $summary->[4]->[$d[4]]++;
  $summary->[5]->[$d[5]]++;
  foreach my $c (@c) {
    $summary->[6]->[$c]++;
  }
  if ($d[7]) {
    $offer->{$email} = $d[7];
    $offer->{$email} =~ s/<BR>/=BREAKLINE=/g;
    $offer->{$email} =~ s/</&lt\;/g;
    $offer->{$email} =~ s/>/&gt\;/g;
    $offer->{$email} =~ s/=BREAKLINE=/<BR>/g;
  }

  if ($in{'email'} && ($email eq $in{'email'})) {
    &print_data($summary->[0]->[0], $email, \@d, \@c, $question, $radio_item,
		$chkbox_item, $offer, $color);
    last;
  }

  &print_data($summary->[0]->[0], $email, \@d, \@c, $question, $radio_item,
             $chkbox_item, $offer, $color)  if ($in{'format'} == 2) ;

  if ($in{'format'} == 3) {
    if (($summary->[0]->[0] >  $next[2]) &&
	($summary->[0]->[0] <= $next[1] + $next[2]))
      {
	&print_data($summary->[0]->[0], $email, \@d, \@c, $question, 
		    $radio_item, $chkbox_item, $offer, $color);
      }
  }

}
undef $H;
untie %index;

if ($in{'format'} == 1) {
  &print_summary($summary, $question, $radio_item, 
		 $chkbox_item, $offer, $color);
}

if ($in{'format'} == 4) {
  &print_comment($question, $offer, $name, $color);
}

if ($in{'format'} == 5) {
  &print_persons(\@email_addr, $name, $color);
}

$next[0] = 5 if $in{'email'};  
if ($in{'format'} == 3) {
  $next[2] = $next[1] + $next[2];
  if ($next[2] >= $summary->[0]->[0]) {
    print "<HR>ʾ $summary->[0]->[0] ǽǤ.\n";
    $next[2] = 0;
    $next[0] = 1;
  }
}

jfenq::print_toc(@next,$summary->[0]->[0],0);

jfenq::print_html_footer unless $debug;
exit;

sub print_data {
  my ($i, $email, $d, $c, $question, $radio_item,
      $chkbox_item, $offer, $color) = @_;
  print <<"ROF";
<P><TABLE  WIDTH="95%" BORDER=0>
<TR><TD BGCOLOR="$color->[0]" ALIGN="right">$i</TD>
    <TD BGCOLOR="$color->[0]">̾: $d->[0]</TD>
    <TD BGCOLOR="$color->[0]">Email: $email</TD></TR>
<TR><TD BGCOLOR="$color->[0]">Q-1</TD>
    <TD BGCOLOR="$color->[1]">$question->[1]</TD>
    <TD>$radio_item->[1]->[$d->[1]]</TD></TR>
<TR><TD BGCOLOR="$color->[0]">Q-2</TD>
    <TD BGCOLOR="$color->[1]">$question->[2]</TD>
    <TD>$radio_item->[2]->[$d->[2]]</TD></TR>
<TR><TD BGCOLOR="$color->[0]">Q-3</TD>
    <TD BGCOLOR="$color->[1]">$question->[3]</TD>
    <TD>$radio_item->[3]->[$d->[3]]</TD></TR>
<TR><TD BGCOLOR="$color->[0]">Q-4</TD>
    <TD BGCOLOR="$color->[1]">$question->[4]</TD>
    <TD>$radio_item->[4]->[$d->[4]]</TD></TR>
<TR><TD BGCOLOR="$color->[0]">Q-5</TD>
    <TD BGCOLOR="$color->[1]">$question->[5]</TD>
    <TD>$radio_item->[5]->[$d->[5]]</TD></TR>
<TR><TD BGCOLOR="$color->[0]">Q-6</TD>
    <TD BGCOLOR="$color->[1]">$question->[6]</TD><TD></TD></TR>
ROF

  foreach my $p (@$c) {
    print "<TR><TD></TD><TD></TD><TD>$chkbox_item->[6]->[$p]</TD></TR>\n";
  }

  if ($offer->{$email}) {
  print <<OFFER;
<TR><TD BGCOLOR="$color->[0]">Q-7</TD>
    <TD BGCOLOR="$color->[1]">$question->[7]</TD><TD></TD></TR>
<TR><TD></TD><TD>
$offer->{$email}
    </TD><TD></TD></TR>
OFFER
  }
print "</TABLE></P>\n";
}

sub print_summary {
  my ($summary, $question, $radio_item, $chkbox_item, $offer, $color) = @_;
  my $result = "<TD BGCOLOR=\"$color->[1]\"></TD>";
  print <<"SUMMARY-ONE";

<H2>󥱡ȷ: ͭ: $summary->[0]->[0]</H2>

<TABLE WIDTH="95%" BORDER=0>
<TR><TD BGCOLOR="$color->[0]">Q-1</TD><TD BGCOLOR="$color->[1]">$question->[1]</TD>$result</TR>
<TR><TD></TD><TD>$radio_item->[1]->[1]</TD><TD>$summary->[1]->[1]</TD></TR>
<TR><TD></TD><TD>$radio_item->[1]->[2]</TD><TD>$summary->[1]->[2]</TD></TR>
<TR><TD BGCOLOR="$color->[0]">Q-2</TD><TD BGCOLOR="$color->[1]">$question->[2]</TD>$result</TR>
<TR><TD></TD><TD>$radio_item->[2]->[1]</TD><TD>$summary->[2]->[1]</TD></TR>
<TR><TD></TD><TD>$radio_item->[2]->[2]</TD><TD>$summary->[2]->[2]</TD></TR>
<TR><TD></TD><TD>$radio_item->[2]->[3]</TD><TD>$summary->[2]->[3]</TD></TR>
<TR><TD BGCOLOR="$color->[0]">Q-3</TD><TD BGCOLOR="$color->[1]">$question->[3]</TD>$result</TR>
<TR><TD></TD><TD>$radio_item->[3]->[1]</TD><TD>$summary->[3]->[1]</TD></TR>
<TR><TD></TD><TD>$radio_item->[3]->[2]</TD><TD>$summary->[3]->[2]</TD></TR>
<TR><TD BGCOLOR="$color->[0]">Q-4</TD><TD BGCOLOR="$color->[1]">$question->[4]</TD>$result</TR>
<TR><TD></TD><TD>$radio_item->[4]->[1]</TD><TD>$summary->[4]->[1]</TD></TR>
<TR><TD></TD><TD>$radio_item->[4]->[2]</TD><TD>$summary->[4]->[2]</TD></TR>
<TR><TD></TD><TD>$radio_item->[4]->[3]</TD><TD>$summary->[4]->[3]</TD></TR>
<TR><TD></TD><TD>$radio_item->[4]->[4]</TD><TD>$summary->[4]->[4]</TD></TR>
<TR><TD BGCOLOR="$color->[0]">Q-5</TD><TD BGCOLOR="$color->[1]">$question->[5]</TD>$result</TR>
<TR><TD></TD><TD>$radio_item->[5]->[1]</TD><TD>$summary->[5]->[1]</TD></TR>
<TR><TD></TD><TD>$radio_item->[5]->[2]</TD><TD>$summary->[5]->[2]</TD></TR>
<TR><TD></TD><TD>$radio_item->[5]->[3]</TD><TD>$summary->[5]->[3]</TD></TR>
<TR><TD></TD><TD>$radio_item->[5]->[4]</TD><TD>$summary->[5]->[4]</TD></TR>
<TR><TD></TD><TD>$radio_item->[5]->[5]</TD><TD>$summary->[5]->[5]</TD></TR>
<TR><TD BGCOLOR="$color->[0]">Q-6</TD><TD BGCOLOR="$color->[1]">$question->[6]</TD>$result</TR>
<TR><TD></TD><TD>$chkbox_item->[6]->[1]</TD><TD>$summary->[6]->[1]</TD></TR>
<TR><TD></TD><TD>$chkbox_item->[6]->[2]</TD><TD>$summary->[6]->[2]</TD></TR>
<TR><TD></TD><TD>$chkbox_item->[6]->[3]</TD><TD>$summary->[6]->[3]</TD></TR>
<TR><TD></TD><TD>$chkbox_item->[6]->[4]</TD><TD>$summary->[6]->[4]</TD></TR>
<TR><TD></TD><TD>$chkbox_item->[6]->[5]</TD><TD>$summary->[6]->[5]</TD></TR>
</TABLE>
SUMMARY-ONE
}

sub print_comment {
  my ($question, $offer, $name, $color) = @_;
  print "<H3>$question->[7]</H3>\n<DL>\n";
  while (my ($mail, $comment) = each %$offer) {
    if ($comment) {
      print "<DT><SPAN CLASS=\"updated\">$name->{$mail} ";
      print " &lt;$mail&gt;</SPAN></DT>\n";
      print "<DD>$comment</DD><HR>\n";
    }
  }
  print "</DL>\n";
}

sub print_persons {
  my($email_addr, $name, $color) = @_;
  print "<H2>԰</H2>\n<OL>\n";
  foreach my $email (@$email_addr) {
    print "<LI><A HREF=\"result.cgi?email=$email\">";
    print "$name->{$email} &lt;$email&gt;</A></LI>\n";
  }
  print "</OL>\n";
}

__END__
