#! /usr/bin/perl

my $basename = shift;
my $imgdir   = shift;
my $image    = "";
my @size     = ();

while (<>) {

  if (/^<A NAME=\"START\-FIGURE:([\w\.]+)\"><\/A>/) {
    $image = $1;
    @size = &getsize($image);
    print "<P><IMG SRC=\"$imgdir/$image\" alt=\"[$image]\" ";
    print "width=\"$size[0]\" height=\"$size[1]\">\n";
    print $_;
    next;
  }

  if (/^<A NAME=\"END\-FIGURE/) {
    $image = "";
    @size = ();
  }

  print unless $image;
}

sub getsize {
  $image = $_[0];
  my ($width, $height);
  open(F, "file $imgdir/$image | ") or die;
  while (<F>) {
    if (/GIF image data.* (\d+) x (\d+),/) {
      ($width, $height) = ($1, $2);
    } elsif (/JPEG image data/) {
      open(D, "djpeg -debug -outfile /dev/null $imgdir/$image 2>&1 |" ) or die;
      while (<D>) {
	if (/Start Of Frame .*: width=(\d+), height=(\d+),/) {
	  ($width, $height) = ($1, $2);
	}
      }
      close D;
    }
  }
  close F;
  return ($width, $height);
}
