
#include "stdafx.h"
#include "../../../include/Graphic/Shader/KaiShader.h"
#include "../../../include/Graphic/KaiGL.h"
//#include "../../../include/Graphic/Texture/KaiTexture.h"
//#include "../../../../Kai/external/DXUT/Core/DXUT.h"




KAI_NAMESPACE_START


// RXgN^
KaiShader::KaiShader() :
	m_pEffect(NULL),
	m_pTechnique(NULL),
	m_pWorldVariable(NULL),
	m_pViewVariable(NULL),
	m_pProjectionVariable(NULL),
	m_pMeshColorVariable(NULL),
	m_pDiffuseVariable(NULL)
{
}


// fXgN^
KaiShader::~KaiShader()
{
	// I
	Terminate();
}


void
KaiShader::Terminate(void)
{
    SAFE_RELEASE(m_pEffect);
}


// I[v
bool
KaiShader::Open(const HTChar* a_shaderFilePath)
{
	// Read the D3DX effect file
    DWORD dwShaderFlags = D3D10_SHADER_ENABLE_STRICTNESS;
	#if defined( DEBUG ) || defined( _DEBUG )
		// Set the D3D10_SHADER_DEBUG flag to embed debug information in the shaders.
		// Setting this flag improves the shader debugging experience, but still allows 
		// the shaders to be optimized and to run exactly the way they will run in 
		// the release configuration of this program.
		dwShaderFlags |= D3D10_SHADER_DEBUG;
    #endif
    HRESULT	hr = D3DX10CreateEffectFromFile(
					a_shaderFilePath, NULL, NULL, "fx_4_0", dwShaderFlags, 0, KaiGL::GetNowDevice(), NULL, NULL, &m_pEffect, NULL, NULL );
	if (FAILED(hr)) {
		MessageBox( NULL, L"The FX file cannot be located.  Please run this executable from the directory that contains the FX file.", L"Error", MB_OK );
		return false;
	}

	m_pTechnique = m_pEffect->GetTechniqueByName( "Render" );
	m_pWorldVariable = m_pEffect->GetVariableByName( "World" )->AsMatrix();
	m_pViewVariable = m_pEffect->GetVariableByName( "View" )->AsMatrix();
	m_pProjectionVariable = m_pEffect->GetVariableByName( "Projection" )->AsMatrix();
	m_pMeshColorVariable = m_pEffect->GetVariableByName( "vMeshColor" )->AsVector();
	m_pDiffuseVariable = m_pEffect->GetVariableByName( "txDiffuse" )->AsShaderResource();
	return true;
}




KAI_NAMESPACE_END
