
#include "stdafx.h"
#include "../../../include/Graphic/Prim/KaiPrimCube00.h"
#include "../../../include/Graphic/KaiGL.h"
//#include "../../../include/Graphic/Texture/KaiTexture.h"
//#include "../../../../Kai/external/DXUT/Core/DXUT.h"




KAI_NAMESPACE_START


struct SimpleVertex
{
    D3DXVECTOR3 Pos;
    D3DXVECTOR2 Tex;
};


// RXgN^
KaiPrimCube00::KaiPrimCube00(ID3D10Device* a_pD3DDevice, KaiShader* a_pShader) :
	m_pVertexLayout(NULL),
	m_pVertexBuffer(NULL),
	m_pIndexBuffer(NULL),
	m_pShader(a_pShader),
	m_pWorldMatrix(NULL),
	m_pMeshColor(NULL)
{
	m_pWorldMatrix = new D3DXMATRIX;
	D3DXMatrixIdentity(m_pWorldMatrix);

	m_pMeshColor = new D3DXVECTOR4( 0.7f, 0.7f, 0.7f, 1.0f );

	// Define the input layout
	D3D10_INPUT_ELEMENT_DESC layout[] = {
		{ "POSITION", 0, DXGI_FORMAT_R32G32B32_FLOAT, 0, 0, D3D10_INPUT_PER_VERTEX_DATA, 0 },
		{ "TEXCOORD", 0, DXGI_FORMAT_R32G32_FLOAT, 0, 12, D3D10_INPUT_PER_VERTEX_DATA, 0 },
	};
	UINT numElements = sizeof( layout ) / sizeof( layout[0] );

	// Create the input layout
	D3D10_PASS_DESC PassDesc;
	a_pShader->GetTechniqueP()->GetPassByIndex( 0 )->GetDesc( &PassDesc );
//	V_RETURN( a_pD3DDevice->CreateInputLayout( layout, numElements, PassDesc.pIAInputSignature, PassDesc.IAInputSignatureSize, &m_pVertexLayout ) );
//	#define V_RETURN(x)    { hr = (x); if( FAILED(hr) ) { return DXUTTrace( __FILE__, (DWORD)__LINE__, hr, L#x, true ); } }
	HRESULT		hr = a_pD3DDevice->CreateInputLayout( layout, numElements, PassDesc.pIAInputSignature, PassDesc.IAInputSignatureSize, &m_pVertexLayout);
	if (FAILED(hr)) {
//		return DXUTTrace( __FILE__, (DWORD)__LINE__, hr, L#x, true );
	}

	// Set the input layout
	a_pD3DDevice->IASetInputLayout( m_pVertexLayout );

	// Create vertex buffer
	SimpleVertex vertices[] = {
		{ D3DXVECTOR3( -1.0f, 1.0f, -1.0f ), D3DXVECTOR2( 0.0f, 0.0f ) },
		{ D3DXVECTOR3( 1.0f, 1.0f, -1.0f ), D3DXVECTOR2( 1.0f, 0.0f ) },
		{ D3DXVECTOR3( 1.0f, 1.0f, 1.0f ), D3DXVECTOR2( 1.0f, 1.0f ) },
		{ D3DXVECTOR3( -1.0f, 1.0f, 1.0f ), D3DXVECTOR2( 0.0f, 1.0f ) },

		{ D3DXVECTOR3( -1.0f, -1.0f, -1.0f ), D3DXVECTOR2( 0.0f, 0.0f ) },
		{ D3DXVECTOR3( 1.0f, -1.0f, -1.0f ), D3DXVECTOR2( 1.0f, 0.0f ) },
		{ D3DXVECTOR3( 1.0f, -1.0f, 1.0f ), D3DXVECTOR2( 1.0f, 1.0f ) },
		{ D3DXVECTOR3( -1.0f, -1.0f, 1.0f ), D3DXVECTOR2( 0.0f, 1.0f ) },

		{ D3DXVECTOR3( -1.0f, -1.0f, 1.0f ), D3DXVECTOR2( 0.0f, 0.0f ) },
		{ D3DXVECTOR3( -1.0f, -1.0f, -1.0f ), D3DXVECTOR2( 1.0f, 0.0f ) },
		{ D3DXVECTOR3( -1.0f, 1.0f, -1.0f ), D3DXVECTOR2( 1.0f, 1.0f ) },
		{ D3DXVECTOR3( -1.0f, 1.0f, 1.0f ), D3DXVECTOR2( 0.0f, 1.0f ) },

		{ D3DXVECTOR3( 1.0f, -1.0f, 1.0f ), D3DXVECTOR2( 0.0f, 0.0f ) },
		{ D3DXVECTOR3( 1.0f, -1.0f, -1.0f ), D3DXVECTOR2( 1.0f, 0.0f ) },
		{ D3DXVECTOR3( 1.0f, 1.0f, -1.0f ), D3DXVECTOR2( 1.0f, 1.0f ) },
		{ D3DXVECTOR3( 1.0f, 1.0f, 1.0f ), D3DXVECTOR2( 0.0f, 1.0f ) },

		{ D3DXVECTOR3( -1.0f, -1.0f, -1.0f ), D3DXVECTOR2( 0.0f, 0.0f ) },
		{ D3DXVECTOR3( 1.0f, -1.0f, -1.0f ), D3DXVECTOR2( 1.0f, 0.0f ) },
		{ D3DXVECTOR3( 1.0f, 1.0f, -1.0f ), D3DXVECTOR2( 1.0f, 1.0f ) },
		{ D3DXVECTOR3( -1.0f, 1.0f, -1.0f ), D3DXVECTOR2( 0.0f, 1.0f ) },

		{ D3DXVECTOR3( -1.0f, -1.0f, 1.0f ), D3DXVECTOR2( 0.0f, 0.0f ) },
		{ D3DXVECTOR3( 1.0f, -1.0f, 1.0f ), D3DXVECTOR2( 1.0f, 0.0f ) },
		{ D3DXVECTOR3( 1.0f, 1.0f, 1.0f ), D3DXVECTOR2( 1.0f, 1.0f ) },
		{ D3DXVECTOR3( -1.0f, 1.0f, 1.0f ), D3DXVECTOR2( 0.0f, 1.0f ) },
	};

	D3D10_BUFFER_DESC bd;
	bd.Usage = D3D10_USAGE_DEFAULT;
	bd.ByteWidth = sizeof( SimpleVertex ) * 24;
	bd.BindFlags = D3D10_BIND_VERTEX_BUFFER;
	bd.CPUAccessFlags = 0;
	bd.MiscFlags = 0;
	D3D10_SUBRESOURCE_DATA InitData;
	InitData.pSysMem = vertices;
//	V_RETURN( a_pD3DDevice->CreateBuffer( &bd, &InitData, &m_pVertexBuffer ) );
	hr = a_pD3DDevice->CreateBuffer(&bd, &InitData, &m_pVertexBuffer);
	if (FAILED(hr)) {
//		return DXUTTrace( __FILE__, (DWORD)__LINE__, hr, L#x, true );
	}

	// Set vertex buffer
	UINT stride = sizeof( SimpleVertex );
	UINT offset = 0;
	a_pD3DDevice->IASetVertexBuffers( 0, 1, &m_pVertexBuffer, &stride, &offset );

	// Create index buffer
	// Create vertex buffer
	DWORD indices[] = {
		3,1,0,
		2,1,3,

		6,4,5,
		7,4,6,

		11,9,8,
		10,9,11,

		14,12,13,
		15,12,14,

		19,17,16,
		18,17,19,

		22,20,21,
		23,20,22
	};

	bd.Usage = D3D10_USAGE_DEFAULT;
	bd.ByteWidth = sizeof( DWORD ) * 36;
	bd.BindFlags = D3D10_BIND_INDEX_BUFFER;
	bd.CPUAccessFlags = 0;
	bd.MiscFlags = 0;
	InitData.pSysMem = indices;
//	V_RETURN( a_pD3DDevice->CreateBuffer( &bd, &InitData, &m_pIndexBuffer));
	hr = a_pD3DDevice->CreateBuffer(&bd, &InitData, &m_pIndexBuffer);
	if (FAILED(hr)) {
//		return DXUTTrace( __FILE__, (DWORD)__LINE__, hr, L#x, true );
	}

	// Set index buffer
	a_pD3DDevice->IASetIndexBuffer(m_pIndexBuffer, DXGI_FORMAT_R32_UINT, 0 );

	// Set primitive topology
	a_pD3DDevice->IASetPrimitiveTopology( D3D10_PRIMITIVE_TOPOLOGY_TRIANGLELIST );
}


// fXgN^
KaiPrimCube00::~KaiPrimCube00()
{
	SAFE_RELEASE(m_pVertexBuffer);
	SAFE_RELEASE(m_pIndexBuffer);
	SAFE_RELEASE(m_pVertexLayout);
}


// Ont[Move
void
KaiPrimCube00::OnMove(double a_time, float a_elapsedTime)
{
	// Update our time
	D3DXMatrixRotationY(m_pWorldMatrix, (float)a_time/10.0f);
}


// OnRender
void
KaiPrimCube00::OnRender(ID3D10Device* a_pD3DDevice)
{
//	D3DXMATRIX							worldMatrix;
//	D3DXMatrixIdentity(&worldMatrix);
//	m_pShader->GetWorldMatrixP()->SetMatrix((float*)&worldMatrix);
	m_pShader->GetWorldMatrixP()->SetMatrix((float*)m_pWorldMatrix);
	m_pShader->GetColorP()->SetFloatVector( ( float* )*m_pMeshColor );

	//
	// Render the cube
	//
	D3D10_TECHNIQUE_DESC techDesc;
	ID3D10EffectTechnique*	pTech = m_pShader->GetTechniqueP();
	pTech->GetDesc( &techDesc );
	for( UINT passIdx = 0; passIdx<techDesc.Passes; ++passIdx ) {
		pTech->GetPassByIndex( passIdx )->Apply( 0 );
		a_pD3DDevice->DrawIndexed( 36, 0, 0 );
	}
}



KAI_NAMESPACE_END
